/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.bootstrap.service;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.nifi.controller.flow.VersionedDataflow;
import org.apache.nifi.minifi.bootstrap.RunMiNiFi;
import org.apache.nifi.minifi.bootstrap.configuration.ConfigurationChangeException;
import org.apache.nifi.minifi.bootstrap.configuration.ConfigurationChangeListener;
import org.apache.nifi.minifi.bootstrap.service.BootstrapFileProvider;
import org.apache.nifi.minifi.commons.api.MiNiFiProperties;
import org.apache.nifi.minifi.commons.service.FlowEnrichService;
import org.apache.nifi.minifi.commons.service.FlowSerDeService;
import org.apache.nifi.minifi.commons.util.FlowUpdateUtils;
import org.apache.nifi.minifi.properties.BootstrapProperties;
import org.slf4j.Logger;

public class MiNiFiConfigurationChangeListener
implements ConfigurationChangeListener {
    private static final ReentrantLock handlingLock = new ReentrantLock();
    private final RunMiNiFi runner;
    private final Logger logger;
    private final BootstrapFileProvider bootstrapFileProvider;
    private final FlowEnrichService flowEnrichService;
    private final FlowSerDeService flowSerDeService;

    public MiNiFiConfigurationChangeListener(RunMiNiFi runner, Logger logger, BootstrapFileProvider bootstrapFileProvider, FlowEnrichService flowEnrichService, FlowSerDeService flowSerDeService) {
        this.runner = runner;
        this.logger = logger;
        this.bootstrapFileProvider = bootstrapFileProvider;
        this.flowEnrichService = flowEnrichService;
        this.flowSerDeService = flowSerDeService;
    }

    @Override
    public void handleChange(InputStream flowConfigInputStream) throws ConfigurationChangeException {
        this.logger.info("Received notification of a change");
        if (!handlingLock.tryLock()) {
            throw new ConfigurationChangeException("Instance is already handling another change");
        }
        Path currentFlowConfigFile = null;
        Path backupFlowConfigFile = null;
        Path currentRawFlowConfigFile = null;
        Path backupRawFlowConfigFile = null;
        try {
            BootstrapProperties bootstrapProperties = this.bootstrapFileProvider.getBootstrapProperties();
            currentFlowConfigFile = Path.of(bootstrapProperties.getProperty(MiNiFiProperties.NIFI_MINIFI_FLOW_CONFIG.getKey()), new String[0]).toAbsolutePath();
            backupFlowConfigFile = Path.of(String.valueOf(currentFlowConfigFile) + ".backup", new String[0]);
            String currentFlowConfigFileBaseName = FilenameUtils.getBaseName((String)currentFlowConfigFile.toString());
            currentRawFlowConfigFile = currentFlowConfigFile.getParent().resolve(currentFlowConfigFileBaseName + ".raw");
            backupRawFlowConfigFile = currentFlowConfigFile.getParent().resolve(currentFlowConfigFileBaseName + ".raw.backup");
            FlowUpdateUtils.backup((Path)currentFlowConfigFile, (Path)backupFlowConfigFile);
            FlowUpdateUtils.backup((Path)currentRawFlowConfigFile, (Path)backupRawFlowConfigFile);
            byte[] rawFlow = IOUtils.toByteArray((InputStream)flowConfigInputStream);
            VersionedDataflow rawDataFlow = this.flowSerDeService.deserialize(rawFlow);
            VersionedDataflow enrichedFlow = this.flowEnrichService.enrichFlow(rawDataFlow);
            byte[] serializedEnrichedFlow = this.flowSerDeService.serialize(enrichedFlow);
            FlowUpdateUtils.persist((byte[])serializedEnrichedFlow, (Path)currentFlowConfigFile, (boolean)true);
            this.restartInstance();
            FlowUpdateUtils.persist((byte[])rawFlow, (Path)currentRawFlowConfigFile, (boolean)false);
            this.setActiveFlowReference(ByteBuffer.wrap(rawFlow));
            this.logger.info("MiNiFi has finished reloading successfully and applied the new flow configuration");
        }
        catch (Exception e) {
            try {
                this.logger.error("Configuration update failed. Reverting to previous flow", (Throwable)e);
                FlowUpdateUtils.revert(backupFlowConfigFile, currentFlowConfigFile);
                FlowUpdateUtils.revert(backupRawFlowConfigFile, currentRawFlowConfigFile);
                throw new ConfigurationChangeException("Unable to perform reload of received configuration change", e);
            }
            catch (Throwable throwable) {
                FlowUpdateUtils.removeIfExists(backupFlowConfigFile);
                FlowUpdateUtils.removeIfExists(backupRawFlowConfigFile);
                IOUtils.closeQuietly((InputStream)flowConfigInputStream);
                handlingLock.unlock();
                throw throwable;
            }
        }
        FlowUpdateUtils.removeIfExists((Path)backupFlowConfigFile);
        FlowUpdateUtils.removeIfExists((Path)backupRawFlowConfigFile);
        IOUtils.closeQuietly((InputStream)flowConfigInputStream);
        handlingLock.unlock();
    }

    @Override
    public String getDescriptor() {
        return "MiNiFiConfigurationChangeListener";
    }

    private void setActiveFlowReference(ByteBuffer flowConfig) {
        this.logger.debug("Setting active flow reference {} with content:\n{}", (Object)flowConfig, (Object)new String(flowConfig.array(), StandardCharsets.UTF_8));
        this.runner.getConfigFileReference().set(flowConfig);
    }

    private void restartInstance() throws IOException {
        try {
            this.runner.reload();
        }
        catch (IOException e) {
            throw new IOException("Unable to successfully restart MiNiFi instance after configuration change.", e);
        }
    }
}

