/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.c2.protocol.api;

import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;

public class FlowQueueStatus
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long size;
    private Long sizeMax;
    private Long dataSize;
    private Long dataSizeMax;

    @Schema(description="The number of flow files in the queue", allowableValues={"range[0, 9223372036854775807]"})
    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    @Schema(description="The maximum number of flow files that the queue is configured to hold", allowableValues={"range[0, 9223372036854775807]"})
    public Long getSizeMax() {
        return this.sizeMax;
    }

    public void setSizeMax(Long sizeMax) {
        this.sizeMax = sizeMax;
    }

    @Schema(description="The size (in Bytes) of all flow files in the queue", allowableValues={"range[0, 9223372036854775807]"})
    public Long getDataSize() {
        return this.dataSize;
    }

    public void setDataSize(Long dataSize) {
        this.dataSize = dataSize;
    }

    @Schema(description="The maximum size (in Bytes) that the queue is configured to hold", allowableValues={"range[0, 9223372036854775807]"})
    public Long getDataSizeMax() {
        return this.dataSizeMax;
    }

    public void setDataSizeMax(Long dataSizeMax) {
        this.dataSizeMax = dataSizeMax;
    }

    @Schema(hidden=true)
    public Double getSizeUtilization() {
        return this.size != null && this.sizeMax != null && this.sizeMax > 0L ? Double.valueOf((double)this.size.longValue() / (double)this.sizeMax.longValue()) : null;
    }

    @Schema(hidden=true)
    public Double getDataSizeUtilization() {
        return this.dataSize != null && this.dataSizeMax != null && this.dataSizeMax > 0L ? Double.valueOf((double)this.dataSize.longValue() / (double)this.dataSizeMax.longValue()) : null;
    }
}

