/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.c2.protocol.api;

import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Objects;
import org.apache.nifi.c2.protocol.api.AgentInfo;
import org.apache.nifi.c2.protocol.api.DeviceInfo;
import org.apache.nifi.c2.protocol.api.FlowInfo;
import org.apache.nifi.c2.protocol.api.ResourceInfo;

public class C2Heartbeat
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String identifier;
    private Long created;
    private DeviceInfo deviceInfo;
    private AgentInfo agentInfo;
    private FlowInfo flowInfo;
    private ResourceInfo resourceInfo;

    @Schema(hidden=true)
    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Schema(hidden=true)
    public Long getCreated() {
        return this.created;
    }

    public void setCreated(Long created) {
        this.created = created;
    }

    @Schema(description="Metadata for the device")
    public DeviceInfo getDeviceInfo() {
        return this.deviceInfo;
    }

    public void setDeviceInfo(DeviceInfo deviceInfo) {
        this.deviceInfo = deviceInfo;
    }

    @Schema(description="Metadata for the agent installed on the device")
    public AgentInfo getAgentInfo() {
        return this.agentInfo;
    }

    public void setAgentInfo(AgentInfo agentInfo) {
        this.agentInfo = agentInfo;
    }

    @Schema(description="Metadata for the flow currently deployed to the agent")
    public FlowInfo getFlowInfo() {
        return this.flowInfo;
    }

    public void setFlowInfo(FlowInfo flowInfo) {
        this.flowInfo = flowInfo;
    }

    @Schema(description="Metadata for the resources currently deployed to the agent")
    public ResourceInfo getResourceInfo() {
        return this.resourceInfo;
    }

    public void setResourceInfo(ResourceInfo resourceInfo) {
        this.resourceInfo = resourceInfo;
    }

    @Schema(hidden=true)
    public String getDeviceId() {
        return this.deviceInfo != null ? this.deviceInfo.getIdentifier() : null;
    }

    @Schema(hidden=true)
    public String getAgentId() {
        return this.agentInfo != null ? this.agentInfo.getIdentifier() : null;
    }

    @Schema(hidden=true)
    public String getAgentClass() {
        return this.agentInfo != null ? this.agentInfo.getAgentClass() : null;
    }

    @Schema(hidden=true)
    public String getAgentManifestId() {
        if (this.agentInfo != null && this.agentInfo.getAgentManifest() != null) {
            return this.agentInfo.getAgentManifest().getIdentifier();
        }
        return null;
    }

    @Schema(hidden=true)
    public String getFlowId() {
        return this.flowInfo != null ? this.flowInfo.getFlowId() : null;
    }

    public String toString() {
        return "C2Heartbeat{identifier='" + this.identifier + "', agentClass=" + (this.agentInfo != null ? this.agentInfo.getAgentClass() : "null") + ", agent=" + (this.agentInfo != null ? this.agentInfo.getIdentifier() : "null") + ", device=" + (this.deviceInfo != null ? this.deviceInfo.getIdentifier() : "null") + ", containsManifest=" + (this.agentInfo != null && this.agentInfo.getAgentManifest() != null) + ", created=" + this.created + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        C2Heartbeat that = (C2Heartbeat)o;
        return Objects.equals(this.identifier, that.identifier);
    }

    public int hashCode() {
        return Objects.hash(this.identifier);
    }
}

