/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.c2.client.http.url;

import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.c2.client.C2ClientConfig;
import org.apache.nifi.c2.client.http.url.C2UrlProvider;
import org.apache.nifi.c2.client.http.url.LegacyC2UrlProvider;
import org.apache.nifi.c2.client.http.url.ProxyAwareC2UrlProvider;

public class C2UrlProviderFactory {
    private static final String INCORRECT_SETTINGS_ERROR_MESSAGE = "Incorrect configuration. Please revisit C2 URL properties.Either c2.rest.url and c2.rest.url.ack have to be set,either c2.rest.path.base, c2.rest.path.heartbeat and c2.rest.path.acknowledge have to configured";
    private final C2ClientConfig clientConfig;

    public C2UrlProviderFactory(C2ClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    public C2UrlProvider create() {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.clientConfig.getC2RestPathBase(), this.clientConfig.getC2RestPathHeartbeat(), this.clientConfig.getC2RestPathAcknowledge()})) {
            return new ProxyAwareC2UrlProvider(this.clientConfig.getC2RestPathBase(), this.clientConfig.getC2RestPathHeartbeat(), this.clientConfig.getC2RestPathAcknowledge());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.clientConfig.getC2Url(), this.clientConfig.getC2AckUrl()})) {
            return new LegacyC2UrlProvider(this.clientConfig.getC2Url(), this.clientConfig.getC2AckUrl());
        }
        throw new IllegalArgumentException(INCORRECT_SETTINGS_ERROR_MESSAGE);
    }
}

