/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.c2.client.http.url;

import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.c2.client.http.url.C2UrlProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyC2UrlProvider
implements C2UrlProvider {
    private static final Logger LOG = LoggerFactory.getLogger(LegacyC2UrlProvider.class);
    private final String c2Url;
    private final String c2AckUrl;

    LegacyC2UrlProvider(String c2Url, String c2AckUrl) {
        this.c2Url = c2Url;
        this.c2AckUrl = c2AckUrl;
    }

    @Override
    public String getHeartbeatUrl() {
        return this.c2Url;
    }

    @Override
    public String getAcknowledgeUrl() {
        return this.c2AckUrl;
    }

    @Override
    public String getCallbackUrl(String absoluteUrl, String relativeUrl) {
        return Optional.ofNullable(absoluteUrl).filter(StringUtils::isNotBlank).orElseThrow(() -> {
            LOG.error("Provided absolute url was empty or null. Relative urls are not supported with this configuration");
            throw new IllegalArgumentException("Provided absolute url was empty or null. Relative C2 urls are not supported with this configuration");
        });
    }
}

