/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.c2.client;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.nifi.c2.client.IdGenerator;
import org.apache.nifi.c2.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentUuidGenerator
implements IdGenerator {
    private static final Logger logger = LoggerFactory.getLogger(PersistentUuidGenerator.class);
    private final File persistenceLocation;

    public PersistentUuidGenerator(File persistenceLocation) {
        this.persistenceLocation = persistenceLocation;
    }

    @Override
    public String generate() {
        if (this.persistenceLocation.exists()) {
            return this.readFile();
        }
        return this.makeFile();
    }

    private String readFile() {
        try {
            List<String> fileLines = Files.readAllLines(this.persistenceLocation.toPath());
            if (fileLines.size() != 1) {
                throw new IllegalStateException(String.format("The file %s for the persisted identifier has the incorrect format.", this.persistenceLocation));
            }
            String uuid = fileLines.get(0);
            return uuid;
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Could not read file %s for persisted identifier.", this.persistenceLocation), e);
        }
    }

    private String makeFile() {
        try {
            File parentDirectory = this.persistenceLocation.getParentFile();
            FileUtils.ensureDirectoryExistAndCanAccess(parentDirectory);
            String uuid = UUID.randomUUID().toString();
            Files.write(this.persistenceLocation.toPath(), Arrays.asList(uuid), new OpenOption[0]);
            logger.debug("Created identifier {} at {}", (Object)uuid, (Object)this.persistenceLocation);
            return uuid;
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Could not create file %s as persistence file.", this.persistenceLocation), e);
        }
    }
}

