/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.c2.serializer;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.util.Optional;
import org.apache.nifi.c2.protocol.api.OperandType;
import org.apache.nifi.c2.serializer.C2Serializer;
import org.apache.nifi.c2.serializer.OperandTypeDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class C2JacksonSerializer
implements C2Serializer {
    private static final Logger logger = LoggerFactory.getLogger(C2JacksonSerializer.class);
    private final ObjectMapper objectMapper = new ObjectMapper();

    public C2JacksonSerializer() {
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.objectMapper.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
        SimpleModule module = new SimpleModule();
        module.addDeserializer(OperandType.class, (JsonDeserializer)new OperandTypeDeserializer());
        this.objectMapper.registerModule((Module)module);
    }

    @Override
    public <T> Optional<String> serialize(T object) {
        if (object == null) {
            logger.trace("C2 Object was null. Nothing to serialize. Returning empty.");
            return Optional.empty();
        }
        String contentString = null;
        try {
            contentString = this.objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            logger.error("Object serialization to JSON failed", (Throwable)e);
        }
        return Optional.ofNullable(contentString);
    }

    @Override
    public <T> Optional<T> deserialize(String content, Class<T> valueType) {
        if (content == null) {
            logger.trace("Content for deserialization was null. Returning empty");
            return Optional.empty();
        }
        Object responseObject = null;
        try {
            responseObject = this.objectMapper.readValue(content, valueType);
        }
        catch (JsonProcessingException e) {
            logger.error("Object deserialization from JSON failed", (Throwable)e);
        }
        return Optional.ofNullable(responseObject);
    }

    @Override
    public <T> Optional<T> convert(Object content, TypeReference<T> valueType) {
        if (content == null) {
            logger.trace("Content for conversion was null. Returning empty");
            return Optional.empty();
        }
        try {
            return Optional.ofNullable(this.objectMapper.convertValue(content, valueType));
        }
        catch (IllegalArgumentException e) {
            logger.error("Object conversion failed", (Throwable)e);
            return Optional.empty();
        }
    }
}

