/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.serial;

import gnu.io.CommPortIdentifier;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.Enumeration;
import java.util.TooManyListenersException;
import java.util.concurrent.Executor;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.future.DefaultConnectFuture;
import org.apache.mina.core.future.IoFuture;
import org.apache.mina.core.service.AbstractIoConnector;
import org.apache.mina.core.service.TransportMetadata;
import org.apache.mina.core.session.IdleStatusChecker;
import org.apache.mina.core.session.IoSessionConfig;
import org.apache.mina.core.session.IoSessionInitializer;
import org.apache.mina.transport.serial.DefaultSerialSessionConfig;
import org.apache.mina.transport.serial.SerialAddress;
import org.apache.mina.transport.serial.SerialPortUnavailableException;
import org.apache.mina.transport.serial.SerialSessionConfig;
import org.apache.mina.transport.serial.SerialSessionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SerialConnector
extends AbstractIoConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerialConnector.class);
    private IdleStatusChecker idleChecker = new IdleStatusChecker();

    public SerialConnector() {
        this(null);
    }

    public SerialConnector(Executor executor) {
        super((IoSessionConfig)new DefaultSerialSessionConfig(), executor);
        this.executeWorker((Runnable)this.idleChecker.getNotifyingTask(), "idleStatusChecker");
    }

    protected synchronized ConnectFuture connect0(SocketAddress remoteAddress, SocketAddress localAddress, IoSessionInitializer<? extends ConnectFuture> sessionInitializer) {
        Enumeration portList = CommPortIdentifier.getPortIdentifiers();
        SerialAddress portAddress = (SerialAddress)remoteAddress;
        while (portList.hasMoreElements()) {
            CommPortIdentifier portId = (CommPortIdentifier)portList.nextElement();
            if (portId.getPortType() != 1) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Serial port discovered : " + portId.getName());
            }
            if (!portId.getName().equals(portAddress.getName())) continue;
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Serial port found : " + portId.getName());
                }
                SerialPort serialPort = this.initializePort("Apache MINA", portId, portAddress);
                DefaultConnectFuture future = new DefaultConnectFuture();
                SerialSessionImpl session = new SerialSessionImpl(this, this.getListeners(), portAddress, serialPort);
                this.initSession(session, (IoFuture)future, sessionInitializer);
                session.start();
                return future;
            }
            catch (PortInUseException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Port In Use Exception : ", (Throwable)e);
                }
                return DefaultConnectFuture.newFailedFuture((Throwable)e);
            }
            catch (UnsupportedCommOperationException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Comm Exception : ", (Throwable)e);
                }
                return DefaultConnectFuture.newFailedFuture((Throwable)e);
            }
            catch (IOException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("IOException : ", (Throwable)e);
                }
                return DefaultConnectFuture.newFailedFuture((Throwable)e);
            }
            catch (TooManyListenersException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("TooManyListenersException : ", (Throwable)e);
                }
                return DefaultConnectFuture.newFailedFuture((Throwable)e);
            }
        }
        return DefaultConnectFuture.newFailedFuture((Throwable)((Object)new SerialPortUnavailableException("Serial port not found")));
    }

    protected void dispose0() throws Exception {
        this.idleChecker.getNotifyingTask().cancel();
    }

    public TransportMetadata getTransportMetadata() {
        return SerialSessionImpl.METADATA;
    }

    private SerialPort initializePort(String user, CommPortIdentifier portId, SerialAddress portAddress) throws UnsupportedCommOperationException, PortInUseException {
        SerialSessionConfig config = (SerialSessionConfig)this.getSessionConfig();
        long connectTimeout = this.getConnectTimeoutMillis();
        if (connectTimeout > Integer.MAX_VALUE) {
            connectTimeout = Integer.MAX_VALUE;
        }
        SerialPort serialPort = (SerialPort)portId.open(user, (int)connectTimeout);
        serialPort.setSerialPortParams(portAddress.getBauds(), portAddress.getDataBitsForRXTX(), portAddress.getStopBitsForRXTX(), portAddress.getParityForRXTX());
        serialPort.setFlowControlMode(portAddress.getFLowControlForRXTX());
        serialPort.notifyOnDataAvailable(true);
        if (config.isLowLatency()) {
            serialPort.setLowLatency();
        }
        serialPort.setInputBufferSize(config.getInputBufferSize());
        serialPort.setOutputBufferSize(config.getOutputBufferSize());
        if (config.getReceiveThreshold() >= 0) {
            serialPort.enableReceiveThreshold(config.getReceiveThreshold());
        } else {
            serialPort.disableReceiveThreshold();
        }
        return serialPort;
    }

    IdleStatusChecker getIdleStatusChecker0() {
        return this.idleChecker;
    }

    public IoSessionConfig getSessionConfig() {
        return this.sessionConfig;
    }
}

