/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.serial;

import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TooManyListenersException;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.DefaultIoFilterChain;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.service.DefaultTransportMetadata;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.core.service.IoService;
import org.apache.mina.core.service.IoServiceListenerSupport;
import org.apache.mina.core.service.TransportMetadata;
import org.apache.mina.core.session.AbstractIoSession;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.apache.mina.transport.serial.DefaultSerialSessionConfig;
import org.apache.mina.transport.serial.SerialAddress;
import org.apache.mina.transport.serial.SerialConnector;
import org.apache.mina.transport.serial.SerialSession;
import org.apache.mina.transport.serial.SerialSessionConfig;
import org.apache.mina.util.ExceptionMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SerialSessionImpl
extends AbstractIoSession
implements SerialSession,
SerialPortEventListener {
    static final TransportMetadata METADATA = new DefaultTransportMetadata("rxtx", "serial", false, true, SerialAddress.class, SerialSessionConfig.class, new Class[]{IoBuffer.class});
    private final SerialSessionConfig config = new DefaultSerialSessionConfig();
    private final IoProcessor<SerialSessionImpl> processor = new SerialIoProcessor();
    private final IoHandler ioHandler;
    private final IoFilterChain filterChain;
    private final SerialConnector service;
    private final IoServiceListenerSupport serviceListeners;
    private final SerialAddress address;
    private final SerialPort port;
    private final Logger log;
    private InputStream inputStream;
    private OutputStream outputStream;
    private final Object writeMonitor = new Object();
    private WriteWorker writeWorker;
    private final Object readReadyMonitor = new Object();

    SerialSessionImpl(SerialConnector service, IoServiceListenerSupport serviceListeners, SerialAddress address, SerialPort port) {
        this.service = service;
        this.serviceListeners = serviceListeners;
        this.ioHandler = service.getHandler();
        this.filterChain = new DefaultIoFilterChain((AbstractIoSession)this);
        this.port = port;
        this.address = address;
        this.log = LoggerFactory.getLogger(SerialSessionImpl.class);
    }

    @Override
    public SerialSessionConfig getConfig() {
        return this.config;
    }

    public IoFilterChain getFilterChain() {
        return this.filterChain;
    }

    public IoHandler getHandler() {
        return this.ioHandler;
    }

    public TransportMetadata getTransportMetadata() {
        return METADATA;
    }

    @Override
    public SerialAddress getLocalAddress() {
        return null;
    }

    @Override
    public SerialAddress getRemoteAddress() {
        return this.address;
    }

    @Override
    public SerialAddress getServiceAddress() {
        return (SerialAddress)super.getServiceAddress();
    }

    public IoService getService() {
        return this.service;
    }

    void start() throws IOException, TooManyListenersException {
        this.inputStream = this.port.getInputStream();
        this.outputStream = this.port.getOutputStream();
        ReadWorker w = new ReadWorker();
        w.start();
        this.port.addEventListener((SerialPortEventListener)this);
        this.service.getIdleStatusChecker0().addSession((AbstractIoSession)this);
        try {
            this.getService().getFilterChainBuilder().buildFilterChain(this.getFilterChain());
            this.serviceListeners.fireSessionCreated((IoSession)this);
        }
        catch (Throwable e) {
            this.getFilterChain().fireExceptionCaught(e);
            this.processor.remove((IoSession)this);
        }
    }

    private void flushWrites() {
        WriteRequest req;
        while ((req = this.getCurrentWriteRequest()) != null || (req = this.getWriteRequestQueue().poll((IoSession)this)) != null) {
            IoBuffer buf = (IoBuffer)req.getMessage();
            if (buf.remaining() == 0) {
                this.setCurrentWriteRequest(null);
                buf.reset();
                this.getFilterChain().fireMessageSent(req);
                continue;
            }
            int writtenBytes = buf.remaining();
            try {
                this.outputStream.write(buf.array(), buf.position(), writtenBytes);
                buf.position(buf.position() + writtenBytes);
                req.getFuture().setWritten();
            }
            catch (IOException e) {
                this.getFilterChain().fireExceptionCaught((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialEvent(SerialPortEvent evt) {
        if (evt.getEventType() == 1) {
            Object object = this.readReadyMonitor;
            synchronized (object) {
                this.readReadyMonitor.notifyAll();
            }
        }
    }

    public IoProcessor<SerialSessionImpl> getProcessor() {
        return this.processor;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SerialIoProcessor
    implements IoProcessor<SerialSessionImpl> {
        private SerialIoProcessor() {
        }

        public void add(SerialSessionImpl session) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush(SerialSessionImpl session) {
            if (SerialSessionImpl.this.writeWorker == null) {
                SerialSessionImpl.this.writeWorker = new WriteWorker();
                SerialSessionImpl.this.writeWorker.start();
            } else {
                Object object = SerialSessionImpl.this.writeMonitor;
                synchronized (object) {
                    SerialSessionImpl.this.writeMonitor.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(SerialSessionImpl session) {
            try {
                SerialSessionImpl.this.inputStream.close();
            }
            catch (IOException e) {
                ExceptionMonitor.getInstance().exceptionCaught((Throwable)e);
            }
            try {
                SerialSessionImpl.this.outputStream.close();
            }
            catch (IOException e) {
                ExceptionMonitor.getInstance().exceptionCaught((Throwable)e);
            }
            SerialSessionImpl.this.port.close();
            this.flush(session);
            Object object = SerialSessionImpl.this.readReadyMonitor;
            synchronized (object) {
                SerialSessionImpl.this.readReadyMonitor.notifyAll();
            }
            SerialSessionImpl.this.serviceListeners.fireSessionDestroyed((IoSession)SerialSessionImpl.this);
        }

        public void updateTrafficControl(SerialSessionImpl session) {
            throw new UnsupportedOperationException();
        }

        public void dispose() {
        }

        public boolean isDisposed() {
            return false;
        }

        public boolean isDisposing() {
            return false;
        }
    }

    private class ReadWorker
    extends Thread {
        private ReadWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (SerialSessionImpl.this.isConnected() && !SerialSessionImpl.this.isClosing()) {
                Object object = SerialSessionImpl.this.readReadyMonitor;
                synchronized (object) {
                    try {
                        SerialSessionImpl.this.readReadyMonitor.wait();
                    }
                    catch (InterruptedException e) {
                        SerialSessionImpl.this.log.error("InterruptedException", (Throwable)e);
                    }
                    if (SerialSessionImpl.this.isClosing() || !SerialSessionImpl.this.isConnected()) {
                        break;
                    }
                    try {
                        int dataSize = SerialSessionImpl.this.inputStream.available();
                        byte[] data = new byte[dataSize];
                        int readBytes = SerialSessionImpl.this.inputStream.read(data);
                        if (readBytes > 0) {
                            IoBuffer buf = IoBuffer.wrap((byte[])data, (int)0, (int)readBytes);
                            buf.put(data, 0, readBytes);
                            buf.flip();
                            SerialSessionImpl.this.getFilterChain().fireMessageReceived((Object)buf);
                        }
                    }
                    catch (IOException e) {
                        SerialSessionImpl.this.getFilterChain().fireExceptionCaught((Throwable)e);
                    }
                }
            }
        }
    }

    private class WriteWorker
    extends Thread {
        private WriteWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (SerialSessionImpl.this.isConnected() && !SerialSessionImpl.this.isClosing()) {
                SerialSessionImpl.this.flushWrites();
                Object object = SerialSessionImpl.this.writeMonitor;
                synchronized (object) {
                    try {
                        SerialSessionImpl.this.writeMonitor.wait();
                    }
                    catch (InterruptedException e) {
                        SerialSessionImpl.this.log.error("InterruptedException", (Throwable)e);
                    }
                }
            }
        }
    }
}

