/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.apr;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import org.apache.mina.core.RuntimeIoException;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.file.FileRegion;
import org.apache.mina.core.polling.AbstractPollingIoProcessor;
import org.apache.mina.core.session.SessionState;
import org.apache.mina.transport.socket.apr.AprLibrary;
import org.apache.mina.transport.socket.apr.AprSession;
import org.apache.tomcat.jni.Error;
import org.apache.tomcat.jni.File;
import org.apache.tomcat.jni.Poll;
import org.apache.tomcat.jni.Pool;
import org.apache.tomcat.jni.Socket;
import org.apache.tomcat.jni.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AprIoProcessor
extends AbstractPollingIoProcessor<AprSession> {
    private static final int POLLSET_SIZE = 1024;
    private final Map<Long, AprSession> allSessions = new HashMap<Long, AprSession>(1024);
    private final Object wakeupLock = new Object();
    private final long wakeupSocket;
    private volatile boolean toBeWakenUp;
    private final long pool;
    private final long bufferPool;
    private final long pollset;
    private final long[] polledSockets = new long[2048];
    private final Queue<AprSession> polledSessions = new ConcurrentLinkedQueue<AprSession>();

    public AprIoProcessor(Executor executor) {
        super(executor);
        this.pool = Pool.create((long)AprLibrary.getInstance().getRootPool());
        this.bufferPool = Pool.create((long)AprLibrary.getInstance().getRootPool());
        try {
            this.wakeupSocket = Socket.create((int)1, (int)1, (int)17, (long)this.pool);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (java.lang.Error e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeIoException("Failed to create a wakeup socket.", (Throwable)e);
        }
        boolean success = false;
        try {
            long newPollset = Poll.create((int)1024, (long)this.pool, (int)1, (long)Long.MAX_VALUE);
            if (newPollset == 0L) {
                newPollset = Poll.create((int)62, (long)this.pool, (int)1, (long)Long.MAX_VALUE);
            }
            this.pollset = newPollset;
            if (this.pollset < 0L && Status.APR_STATUS_IS_ENOTIMPL((int)(-((int)this.pollset)))) {
                throw new RuntimeIoException("Thread-safe pollset is not supported in this platform.");
            }
            success = true;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (java.lang.Error e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeIoException("Failed to create a pollset.", (Throwable)e);
        }
        finally {
            if (!success) {
                this.dispose();
            }
        }
    }

    protected void doDispose() {
        Poll.destroy((long)this.pollset);
        Socket.close((long)this.wakeupSocket);
        Pool.destroy((long)this.bufferPool);
        Pool.destroy((long)this.pool);
    }

    protected int select() throws Exception {
        return this.select(Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int select(long timeout) throws Exception {
        int rv = Poll.poll((long)this.pollset, (long)(1000L * timeout), (long[])this.polledSockets, (boolean)false);
        if (rv <= 0) {
            if (rv != -120001) {
                this.throwException(rv);
            }
            if ((rv = Poll.maintain((long)this.pollset, (long[])this.polledSockets, (boolean)true)) > 0) {
                for (int i = 0; i < rv; ++i) {
                    long socket = this.polledSockets[i];
                    AprSession session = this.allSessions.get(socket);
                    if (session == null) continue;
                    int flag = (session.isInterestedInRead() ? 1 : 0) | (session.isInterestedInWrite() ? 4 : 0);
                    Poll.add((long)this.pollset, (long)socket, (int)flag);
                }
            } else if (rv < 0) {
                this.throwException(rv);
            }
            return 0;
        }
        rv <<= 1;
        if (!this.polledSessions.isEmpty()) {
            this.polledSessions.clear();
        }
        for (int i = 0; i < rv; ++i) {
            long socket;
            long flag = this.polledSockets[i];
            if ((socket = this.polledSockets[++i]) == this.wakeupSocket) {
                Object object = this.wakeupLock;
                synchronized (object) {
                    Poll.remove((long)this.pollset, (long)this.wakeupSocket);
                    this.toBeWakenUp = false;
                    continue;
                }
            }
            AprSession session = this.allSessions.get(socket);
            if (session == null) continue;
            session.setReadable((flag & 1L) != 0L);
            session.setWritable((flag & 4L) != 0L);
            this.polledSessions.add(session);
        }
        return this.polledSessions.size();
    }

    protected boolean isSelectorEmpty() {
        return this.allSessions.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void wakeup() {
        if (this.toBeWakenUp) {
            return;
        }
        Object object = this.wakeupLock;
        synchronized (object) {
            this.toBeWakenUp = true;
            Poll.add((long)this.pollset, (long)this.wakeupSocket, (int)4);
        }
    }

    protected Iterator<AprSession> allSessions() {
        return this.allSessions.values().iterator();
    }

    protected Iterator<AprSession> selectedSessions() {
        return this.polledSessions.iterator();
    }

    protected void init(AprSession session) throws Exception {
        long s = session.getDescriptor();
        Socket.optSet((long)s, (int)8, (int)1);
        Socket.timeoutSet((long)s, (long)0L);
        int rv = Poll.add((long)this.pollset, (long)s, (int)1);
        if (rv != 0) {
            this.throwException(rv);
        }
        session.setInterestedInRead(true);
        this.allSessions.put(s, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy(AprSession session) throws Exception {
        if (this.allSessions.remove(session.getDescriptor()) == null) {
            return;
        }
        int ret = Poll.remove((long)this.pollset, (long)session.getDescriptor());
        try {
            if (ret != 0) {
                this.throwException(ret);
            }
        }
        finally {
            ret = Socket.close((long)session.getDescriptor());
            Socket.destroy((long)session.getDescriptor());
            session.setDescriptor(0L);
            if (ret != 0) {
                this.throwException(ret);
            }
        }
    }

    protected SessionState getState(AprSession session) {
        long socket = session.getDescriptor();
        if (socket != 0L) {
            return SessionState.OPENED;
        }
        if (this.allSessions.get(socket) != null) {
            return SessionState.OPENING;
        }
        return SessionState.CLOSING;
    }

    protected boolean isReadable(AprSession session) {
        return session.isReadable();
    }

    protected boolean isWritable(AprSession session) {
        return session.isWritable();
    }

    protected boolean isInterestedInRead(AprSession session) {
        return session.isInterestedInRead();
    }

    protected boolean isInterestedInWrite(AprSession session) {
        return session.isInterestedInWrite();
    }

    protected void setInterestedInRead(AprSession session, boolean isInterested) throws Exception {
        if (session.isInterestedInRead() == isInterested) {
            return;
        }
        int rv = Poll.remove((long)this.pollset, (long)session.getDescriptor());
        if (rv != 0) {
            this.throwException(rv);
        }
        int flags = (isInterested ? 1 : 0) | (session.isInterestedInWrite() ? 4 : 0);
        rv = Poll.add((long)this.pollset, (long)session.getDescriptor(), (int)flags);
        if (rv == 0) {
            session.setInterestedInRead(isInterested);
        } else {
            this.throwException(rv);
        }
    }

    protected void setInterestedInWrite(AprSession session, boolean isInterested) throws Exception {
        if (session.isInterestedInWrite() == isInterested) {
            return;
        }
        int rv = Poll.remove((long)this.pollset, (long)session.getDescriptor());
        if (rv != 0) {
            this.throwException(rv);
        }
        int flags = (session.isInterestedInRead() ? 1 : 0) | (isInterested ? 4 : 0);
        rv = Poll.add((long)this.pollset, (long)session.getDescriptor(), (int)flags);
        if (rv == 0) {
            session.setInterestedInWrite(isInterested);
        } else {
            this.throwException(rv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int read(AprSession session, IoBuffer buffer) throws Exception {
        int bytes;
        int capacity = buffer.remaining();
        ByteBuffer b = Pool.alloc((long)this.bufferPool, (int)capacity);
        try {
            bytes = Socket.recvb((long)session.getDescriptor(), (ByteBuffer)b, (int)0, (int)capacity);
            if (bytes > 0) {
                b.position(0);
                b.limit(bytes);
                buffer.put(b);
            } else if (bytes < 0) {
                if (Status.APR_STATUS_IS_EOF((int)(-bytes))) {
                    bytes = -1;
                } else if (Status.APR_STATUS_IS_EAGAIN((int)(-bytes))) {
                    bytes = 0;
                } else {
                    this.throwException(bytes);
                }
            }
        }
        finally {
            Pool.clear((long)this.bufferPool);
        }
        return bytes;
    }

    protected int write(AprSession session, IoBuffer buf, int length) throws Exception {
        int writtenBytes;
        if (buf.isDirect()) {
            writtenBytes = Socket.sendb((long)session.getDescriptor(), (ByteBuffer)buf.buf(), (int)buf.position(), (int)length);
        } else {
            writtenBytes = Socket.send((long)session.getDescriptor(), (byte[])buf.array(), (int)buf.position(), (int)length);
            if (writtenBytes > 0) {
                buf.skip(writtenBytes);
            }
        }
        if (writtenBytes < 0) {
            if (Status.APR_STATUS_IS_EAGAIN((int)(-writtenBytes))) {
                writtenBytes = 0;
            } else if (Status.APR_STATUS_IS_EOF((int)(-writtenBytes))) {
                writtenBytes = 0;
            } else {
                this.throwException(writtenBytes);
            }
        }
        return writtenBytes;
    }

    protected int transferFile(AprSession session, FileRegion region, int length) throws Exception {
        if (region.getFilename() == null) {
            throw new UnsupportedOperationException();
        }
        long fd = File.open((String)region.getFilename(), (int)4129, (int)0, (long)Socket.pool((long)session.getDescriptor()));
        long numWritten = Socket.sendfilen((long)session.getDescriptor(), (long)fd, (long)region.getPosition(), (long)length, (int)0);
        File.close((long)fd);
        if (numWritten < 0L) {
            if (numWritten == -120002L) {
                return 0;
            }
            throw new IOException(Error.strerror((int)((int)(-numWritten))) + " (code: " + numWritten + ")");
        }
        return (int)numWritten;
    }

    private void throwException(int code) throws IOException {
        throw new IOException(Error.strerror((int)(-code)) + " (code: " + code + ")");
    }

    protected void registerNewSelector() {
    }

    protected boolean isBrokenConnection() throws IOException {
        return true;
    }
}

