/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.apr;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.spi.SelectorProvider;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import org.apache.mina.core.RuntimeIoException;
import org.apache.mina.core.polling.AbstractPollingIoAcceptor;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.core.service.IoService;
import org.apache.mina.core.service.TransportMetadata;
import org.apache.mina.core.session.IoSessionConfig;
import org.apache.mina.transport.socket.DefaultSocketSessionConfig;
import org.apache.mina.transport.socket.apr.AprIoProcessor;
import org.apache.mina.transport.socket.apr.AprLibrary;
import org.apache.mina.transport.socket.apr.AprSession;
import org.apache.mina.transport.socket.apr.AprSocketSession;
import org.apache.tomcat.jni.Address;
import org.apache.tomcat.jni.Error;
import org.apache.tomcat.jni.Poll;
import org.apache.tomcat.jni.Pool;
import org.apache.tomcat.jni.Socket;
import org.apache.tomcat.jni.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AprSocketAcceptor
extends AbstractPollingIoAcceptor<AprSession, Long> {
    private static final int APR_TIMEUP_ERROR = -120001;
    private static final int POLLSET_SIZE = 1024;
    private final Object wakeupLock = new Object();
    private volatile long wakeupSocket;
    private volatile boolean toBeWakenUp;
    private volatile long pool;
    private volatile long pollset;
    private final long[] polledSockets = new long[2048];
    private final Queue<Long> polledHandles = new ConcurrentLinkedQueue<Long>();

    public AprSocketAcceptor() {
        super((IoSessionConfig)new DefaultSocketSessionConfig(), AprIoProcessor.class);
        ((DefaultSocketSessionConfig)this.getSessionConfig()).init((IoService)this);
    }

    public AprSocketAcceptor(int processorCount) {
        super((IoSessionConfig)new DefaultSocketSessionConfig(), AprIoProcessor.class, processorCount);
        ((DefaultSocketSessionConfig)this.getSessionConfig()).init((IoService)this);
    }

    public AprSocketAcceptor(IoProcessor<AprSession> processor) {
        super((IoSessionConfig)new DefaultSocketSessionConfig(), processor);
        ((DefaultSocketSessionConfig)this.getSessionConfig()).init((IoService)this);
    }

    public AprSocketAcceptor(Executor executor, IoProcessor<AprSession> processor) {
        super((IoSessionConfig)new DefaultSocketSessionConfig(), executor, processor);
        ((DefaultSocketSessionConfig)this.getSessionConfig()).init((IoService)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AprSession accept(IoProcessor<AprSession> processor, Long handle) throws Exception {
        long s = Socket.accept((long)handle);
        boolean success = false;
        try {
            AprSocketSession result = new AprSocketSession((IoService)this, processor, s);
            success = true;
            AprSocketSession aprSocketSession = result;
            return aprSocketSession;
        }
        finally {
            if (!success) {
                Socket.close((long)s);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long open(SocketAddress localAddress) throws Exception {
        InetSocketAddress la = (InetSocketAddress)localAddress;
        long handle = Socket.create((int)1, (int)0, (int)6, (long)this.pool);
        boolean success = false;
        try {
            int result = Socket.optSet((long)handle, (int)8, (int)1);
            if (result != 0) {
                this.throwException(result);
            }
            if ((result = Socket.timeoutSet((long)handle, (long)0L)) != 0) {
                this.throwException(result);
            }
            if ((result = Socket.optSet((long)handle, (int)16, (int)(this.isReuseAddress() ? 1 : 0))) != 0) {
                this.throwException(result);
            }
            if ((result = Socket.optSet((long)handle, (int)128, (int)this.getSessionConfig().getReceiveBufferSize())) != 0) {
                this.throwException(result);
            }
            long sa = la != null ? (la.getAddress() == null ? Address.info((String)"0.0.0.0", (int)1, (int)la.getPort(), (int)0, (long)this.pool) : Address.info((String)la.getAddress().getHostAddress(), (int)1, (int)la.getPort(), (int)0, (long)this.pool)) : Address.info((String)"0.0.0.0", (int)1, (int)0, (int)0, (long)this.pool);
            result = Socket.bind((long)handle, (long)sa);
            if (result != 0) {
                this.throwException(result);
            }
            if ((result = Socket.listen((long)handle, (int)this.getBacklog())) != 0) {
                this.throwException(result);
            }
            if ((result = Poll.add((long)this.pollset, (long)handle, (int)1)) != 0) {
                this.throwException(result);
            }
            success = true;
        }
        finally {
            if (!success) {
                this.close(handle);
            }
        }
        return handle;
    }

    protected void init() throws Exception {
        this.pool = Pool.create((long)AprLibrary.getInstance().getRootPool());
        this.wakeupSocket = Socket.create((int)1, (int)1, (int)17, (long)this.pool);
        this.pollset = Poll.create((int)1024, (long)this.pool, (int)1, (long)Long.MAX_VALUE);
        if (this.pollset <= 0L) {
            this.pollset = Poll.create((int)62, (long)this.pool, (int)1, (long)Long.MAX_VALUE);
        }
        if (this.pollset <= 0L && Status.APR_STATUS_IS_ENOTIMPL((int)(-((int)this.pollset)))) {
            throw new RuntimeIoException("Thread-safe pollset is not supported in this platform.");
        }
    }

    protected void destroy() throws Exception {
        if (this.wakeupSocket > 0L) {
            Socket.close((long)this.wakeupSocket);
        }
        if (this.pollset > 0L) {
            Poll.destroy((long)this.pollset);
        }
        if (this.pool > 0L) {
            Pool.destroy((long)this.pool);
        }
    }

    protected SocketAddress localAddress(Long handle) throws Exception {
        long la = Address.get((int)0, (long)handle);
        return new InetSocketAddress(Address.getip((long)la), Address.getInfo((long)la).port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int select() throws Exception {
        int rv = Poll.poll((long)this.pollset, (long)Integer.MAX_VALUE, (long[])this.polledSockets, (boolean)false);
        if (rv <= 0) {
            if (rv != -120001) {
                this.throwException(rv);
            }
            if ((rv = Poll.maintain((long)this.pollset, (long[])this.polledSockets, (boolean)true)) > 0) {
                for (int i = 0; i < rv; ++i) {
                    Poll.add((long)this.pollset, (long)this.polledSockets[i], (int)1);
                }
            } else if (rv < 0) {
                this.throwException(rv);
            }
            return 0;
        }
        rv <<= 1;
        if (!this.polledHandles.isEmpty()) {
            this.polledHandles.clear();
        }
        for (int i = 0; i < rv; ++i) {
            long socket;
            long flag = this.polledSockets[i];
            if ((socket = this.polledSockets[++i]) == this.wakeupSocket) {
                Object object = this.wakeupLock;
                synchronized (object) {
                    Poll.remove((long)this.pollset, (long)this.wakeupSocket);
                    this.toBeWakenUp = false;
                    continue;
                }
            }
            if ((flag & 1L) == 0L) continue;
            this.polledHandles.add(socket);
        }
        return this.polledHandles.size();
    }

    protected Iterator<Long> selectedHandles() {
        return this.polledHandles.iterator();
    }

    protected void close(Long handle) throws Exception {
        Poll.remove((long)this.pollset, (long)handle);
        int result = Socket.close((long)handle);
        if (result != 0) {
            this.throwException(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void wakeup() {
        if (this.toBeWakenUp) {
            return;
        }
        Object object = this.wakeupLock;
        synchronized (object) {
            this.toBeWakenUp = true;
            Poll.add((long)this.pollset, (long)this.wakeupSocket, (int)4);
        }
    }

    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)super.getLocalAddress();
    }

    public InetSocketAddress getDefaultLocalAddress() {
        return (InetSocketAddress)super.getDefaultLocalAddress();
    }

    public void setDefaultLocalAddress(InetSocketAddress localAddress) {
        super.setDefaultLocalAddress((SocketAddress)localAddress);
    }

    public TransportMetadata getTransportMetadata() {
        return AprSocketSession.METADATA;
    }

    private void throwException(int code) throws IOException {
        throw new IOException(Error.strerror((int)(-code)) + " (code: " + code + ")");
    }

    protected void init(SelectorProvider selectorProvider) throws Exception {
        this.init();
    }
}

