/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.statemachine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.mina.statemachine.transition.Transition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class State {
    private final String id;
    private final State parent;
    private List<TransitionHolder> transitionHolders = new ArrayList<TransitionHolder>();
    private List<Transition> transitions = Collections.emptyList();

    public State(String id) {
        this(id, null);
    }

    public State(String id, State parent) {
        this.id = id;
        this.parent = parent;
    }

    public String getId() {
        return this.id;
    }

    public State getParent() {
        return this.parent;
    }

    public List<Transition> getTransitions() {
        return Collections.unmodifiableList(this.transitions);
    }

    private void updateTransitions() {
        this.transitions = new ArrayList<Transition>(this.transitionHolders.size());
        for (TransitionHolder holder : this.transitionHolders) {
            this.transitions.add(holder.transition);
        }
    }

    public State addTransition(Transition transition) {
        return this.addTransition(transition, 0);
    }

    public State addTransition(Transition transition, int weight) {
        if (transition == null) {
            throw new NullPointerException("transition");
        }
        this.transitionHolders.add(new TransitionHolder(transition, weight));
        Collections.sort(this.transitionHolders);
        this.updateTransitions();
        return this;
    }

    public boolean equals(Object o) {
        if (!(o instanceof State)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        State that = (State)o;
        return new EqualsBuilder().append((Object)this.id, (Object)that.id).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(13, 33).append((Object)this.id).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.id).toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TransitionHolder
    implements Comparable<TransitionHolder> {
        Transition transition;
        int weight;

        TransitionHolder(Transition transition, int weight) {
            this.transition = transition;
            this.weight = weight;
        }

        @Override
        public int compareTo(TransitionHolder o) {
            return this.weight > o.weight ? 1 : (this.weight < o.weight ? -1 : 0);
        }
    }
}

