/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.statemachine;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import org.apache.mina.statemachine.BreakAndCallException;
import org.apache.mina.statemachine.BreakAndContinueException;
import org.apache.mina.statemachine.BreakAndGotoException;
import org.apache.mina.statemachine.BreakAndReturnException;
import org.apache.mina.statemachine.NoSuchStateException;
import org.apache.mina.statemachine.State;
import org.apache.mina.statemachine.context.StateContext;
import org.apache.mina.statemachine.event.Event;
import org.apache.mina.statemachine.event.UnhandledEventException;
import org.apache.mina.statemachine.transition.Transition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateMachine {
    private static final Logger log = LoggerFactory.getLogger(StateMachine.class);
    private static final String CALL_STACK = StateMachine.class.getName() + ".callStack";
    private final State startState;
    private final Map<String, State> states;
    private final ThreadLocal<Boolean> processingThreadLocal = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private final ThreadLocal<LinkedList<Event>> eventQueueThreadLocal = new ThreadLocal<LinkedList<Event>>(){

        @Override
        protected LinkedList<Event> initialValue() {
            return new LinkedList<Event>();
        }
    };

    public StateMachine(State[] states, String startStateId) {
        this.states = new HashMap<String, State>();
        for (State s : states) {
            this.states.put(s.getId(), s);
        }
        this.startState = this.getState(startStateId);
    }

    public StateMachine(Collection<State> states, String startStateId) {
        this(states.toArray(new State[0]), startStateId);
    }

    public State getState(String id) throws NoSuchStateException {
        State state = this.states.get(id);
        if (state == null) {
            throw new NoSuchStateException(id);
        }
        return state;
    }

    public Collection<State> getStates() {
        return Collections.unmodifiableCollection(this.states.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Event event) {
        StateContext context;
        StateContext stateContext = context = event.getContext();
        synchronized (stateContext) {
            LinkedList<Event> eventQueue = this.eventQueueThreadLocal.get();
            eventQueue.addLast(event);
            if (this.processingThreadLocal.get().booleanValue()) {
                if (log.isDebugEnabled()) {
                    log.debug("State machine called recursively. Queuing event " + event + " for later processing.");
                }
            } else {
                this.processingThreadLocal.set(true);
                try {
                    if (context.getCurrentState() == null) {
                        context.setCurrentState(this.startState);
                    }
                    this.processEvents(eventQueue);
                }
                finally {
                    this.processingThreadLocal.set(false);
                }
            }
        }
    }

    private void processEvents(LinkedList<Event> eventQueue) {
        while (!eventQueue.isEmpty()) {
            Event event = eventQueue.removeFirst();
            StateContext context = event.getContext();
            this.handle(context.getCurrentState(), event);
        }
    }

    private void handle(State state, Event event) {
        StateContext context = event.getContext();
        for (Transition t : state.getTransitions()) {
            if (log.isDebugEnabled()) {
                log.debug("Trying transition " + t);
            }
            try {
                if (!t.execute(event)) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Transition " + t + " executed successfully.");
                }
                this.setCurrentState(context, t.getNextState());
                return;
            }
            catch (BreakAndContinueException bace) {
                if (!log.isDebugEnabled()) continue;
                log.debug("BreakAndContinueException thrown in transition " + t + ". Continuing with next transition.");
            }
            catch (BreakAndGotoException bage) {
                State newState = this.getState(bage.getStateId());
                if (bage.isNow()) {
                    if (log.isDebugEnabled()) {
                        log.debug("BreakAndGotoException thrown in transition " + t + ". Moving to state " + newState.getId() + " now.");
                    }
                    this.setCurrentState(context, newState);
                    this.handle(newState, event);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("BreakAndGotoException thrown in transition " + t + ". Moving to state " + newState.getId() + " next.");
                    }
                    this.setCurrentState(context, newState);
                }
                return;
            }
            catch (BreakAndCallException bace) {
                State newState = this.getState(bace.getStateId());
                Stack<State> callStack = this.getCallStack(context);
                State returnTo = bace.getReturnToStateId() != null ? this.getState(bace.getReturnToStateId()) : context.getCurrentState();
                callStack.push(returnTo);
                if (bace.isNow()) {
                    if (log.isDebugEnabled()) {
                        log.debug("BreakAndCallException thrown in transition " + t + ". Moving to state " + newState.getId() + " now.");
                    }
                    this.setCurrentState(context, newState);
                    this.handle(newState, event);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("BreakAndCallException thrown in transition " + t + ". Moving to state " + newState.getId() + " next.");
                    }
                    this.setCurrentState(context, newState);
                }
                return;
            }
            catch (BreakAndReturnException bare) {
                Stack<State> callStack = this.getCallStack(context);
                State newState = callStack.pop();
                if (bare.isNow()) {
                    if (log.isDebugEnabled()) {
                        log.debug("BreakAndReturnException thrown in transition " + t + ". Moving to state " + newState.getId() + " now.");
                    }
                    this.setCurrentState(context, newState);
                    this.handle(newState, event);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("BreakAndReturnException thrown in transition " + t + ". Moving to state " + newState.getId() + " next.");
                    }
                    this.setCurrentState(context, newState);
                }
                return;
            }
        }
        if (state.getParent() == null) {
            throw new UnhandledEventException(event);
        }
        this.handle(state.getParent(), event);
    }

    private Stack<State> getCallStack(StateContext context) {
        Stack callStack = (Stack)context.getAttribute(CALL_STACK);
        if (callStack == null) {
            callStack = new Stack();
            context.setAttribute(CALL_STACK, callStack);
        }
        return callStack;
    }

    private void setCurrentState(StateContext context, State newState) {
        if (newState != null) {
            if (log.isDebugEnabled() && newState != context.getCurrentState()) {
                log.debug("Leaving state " + context.getCurrentState().getId());
                log.debug("Entering state " + newState.getId());
            }
            context.setCurrentState(newState);
        }
    }
}

