/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.integration.spring;

import java.util.List;
import org.apache.mina.common.DefaultIoFilterChainBuilder;
import org.apache.mina.common.IoFilter;
import org.apache.mina.integration.spring.IoFilterMapping;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.util.Assert;

public class DefaultIoFilterChainBuilderFactoryBean
extends AbstractFactoryBean {
    private IoFilterMapping[] filterMappings = new IoFilterMapping[0];
    private String prefix = "filter";

    protected Object createInstance() throws Exception {
        DefaultIoFilterChainBuilder builder = new DefaultIoFilterChainBuilder();
        for (int i = 0; i < this.filterMappings.length; ++i) {
            String name = this.filterMappings[i].getName();
            if (name == null) {
                name = this.prefix + i;
            }
            builder.addLast(name, this.filterMappings[i].getFilter());
        }
        return builder;
    }

    public Class getObjectType() {
        return DefaultIoFilterChainBuilder.class;
    }

    public void setFilterNamePrefix(String prefix) {
        Assert.notNull((Object)prefix, (String)"Property 'filterNamePrefix' may not be null");
        this.prefix = prefix;
    }

    public void setFilters(List filters) {
        Assert.notNull((Object)filters, (String)"Property 'filters' may not be null");
        IoFilterMapping[] filterMappings = new IoFilterMapping[filters.size()];
        for (int i = 0; i < filterMappings.length; ++i) {
            Object o = filters.get(i);
            if (o instanceof IoFilterMapping) {
                filterMappings[i] = (IoFilterMapping)o;
                continue;
            }
            if (o instanceof IoFilter) {
                filterMappings[i] = new IoFilterMapping();
                filterMappings[i].setFilter((IoFilter)o);
                continue;
            }
            throw new IllegalArgumentException("List may only contain IoFilter or IoFilterMapping objects. Found object of type " + o.getClass().getName() + " at position " + i + ".");
        }
        this.filterMappings = filterMappings;
    }
}

