/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.integration.spring.ssl;

import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.util.Assert;

public class SSLContextFactoryBean
extends AbstractFactoryBean {
    private String protocol = "TLS";
    private String provider = null;
    private SecureRandom secureRandom = null;
    private KeyStore keyManagerFactoryKeyStore = null;
    private char[] keyManagerFactoryKeyStorePassword = null;
    private KeyManagerFactory keyManagerFactory = null;
    private String keyManagerFactoryAlgorithm = null;
    private String keyManagerFactoryProvider = null;
    private boolean keyManagerFactoryAlgorithmUseDefault = false;
    private KeyStore trustManagerFactoryKeyStore = null;
    private TrustManagerFactory trustManagerFactory = null;
    private String trustManagerFactoryAlgorithm = null;
    private String trustManagerFactoryProvider = null;
    private boolean trustManagerFactoryAlgorithmUseDefault = false;
    private ManagerFactoryParameters trustManagerFactoryParameters = null;

    protected Object createInstance() throws Exception {
        String algorithm;
        KeyManagerFactory kmf = this.keyManagerFactory;
        TrustManagerFactory tmf = this.trustManagerFactory;
        if (kmf == null) {
            algorithm = this.keyManagerFactoryAlgorithm;
            if (algorithm == null && this.keyManagerFactoryAlgorithmUseDefault) {
                algorithm = KeyManagerFactory.getDefaultAlgorithm();
            }
            if (algorithm != null) {
                kmf = this.keyManagerFactoryProvider == null ? KeyManagerFactory.getInstance(algorithm) : KeyManagerFactory.getInstance(algorithm, this.keyManagerFactoryProvider);
            }
        }
        if (tmf == null) {
            algorithm = this.trustManagerFactoryAlgorithm;
            if (algorithm == null && this.trustManagerFactoryAlgorithmUseDefault) {
                algorithm = TrustManagerFactory.getDefaultAlgorithm();
            }
            if (algorithm != null) {
                tmf = this.trustManagerFactoryProvider == null ? TrustManagerFactory.getInstance(algorithm) : TrustManagerFactory.getInstance(algorithm, this.trustManagerFactoryProvider);
            }
        }
        KeyManager[] keyManagers = null;
        if (kmf != null) {
            kmf.init(this.keyManagerFactoryKeyStore, this.keyManagerFactoryKeyStorePassword);
            keyManagers = kmf.getKeyManagers();
        }
        TrustManager[] trustManagers = null;
        if (tmf != null) {
            if (this.trustManagerFactoryParameters != null) {
                tmf.init(this.trustManagerFactoryParameters);
            } else {
                tmf.init(this.trustManagerFactoryKeyStore);
            }
            trustManagers = tmf.getTrustManagers();
        }
        SSLContext context = null;
        context = this.provider == null ? SSLContext.getInstance(this.protocol) : SSLContext.getInstance(this.protocol, this.provider);
        context.init(keyManagers, trustManagers, this.secureRandom);
        return context;
    }

    public Class getObjectType() {
        return SSLContext.class;
    }

    public void setProtocol(String protocol) {
        Assert.notNull((Object)protocol, (String)"Property 'protocol' may not be null");
        this.protocol = protocol;
    }

    public void setKeyManagerFactoryAlgorithmUseDefault(boolean useDefault) {
        this.keyManagerFactoryAlgorithmUseDefault = useDefault;
    }

    public void setTrustManagerFactoryAlgorithmUseDefault(boolean useDefault) {
        this.trustManagerFactoryAlgorithmUseDefault = useDefault;
    }

    public void setKeyManagerFactory(KeyManagerFactory factory) {
        this.keyManagerFactory = factory;
    }

    public void setKeyManagerFactoryAlgorithm(String algorithm) {
        this.keyManagerFactoryAlgorithm = algorithm;
    }

    public void setKeyManagerFactoryProvider(String provider) {
        this.keyManagerFactoryProvider = provider;
    }

    public void setKeyManagerFactoryKeyStore(KeyStore keyStore) {
        this.keyManagerFactoryKeyStore = keyStore;
    }

    public void setKeyManagerFactoryKeyStorePassword(String password) {
        this.keyManagerFactoryKeyStorePassword = (char[])(password != null ? password.toCharArray() : null);
    }

    public void setTrustManagerFactory(TrustManagerFactory factory) {
        this.trustManagerFactory = factory;
    }

    public void setTrustManagerFactoryAlgorithm(String algorithm) {
        this.trustManagerFactoryAlgorithm = algorithm;
    }

    public void setTrustManagerFactoryKeyStore(KeyStore keyStore) {
        this.trustManagerFactoryKeyStore = keyStore;
    }

    public void setTrustManagerFactoryParameters(ManagerFactoryParameters parameters) {
        this.trustManagerFactoryParameters = parameters;
    }

    public void setTrustManagerFactoryProvider(String provider) {
        this.trustManagerFactoryProvider = provider;
    }

    public void setSecureRandom(SecureRandom secureRandom) {
        this.secureRandom = secureRandom;
    }
}

