/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.integration.jmx;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import javax.management.Attribute;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBean;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import ognl.ExpressionSyntaxException;
import ognl.InappropriateExpressionException;
import ognl.NoSuchPropertyException;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.OgnlRuntime;
import ognl.PropertyAccessor;
import ognl.TypeConverter;
import org.apache.mina.core.filterchain.DefaultIoFilterChainBuilder;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.filterchain.IoFilterChainBuilder;
import org.apache.mina.core.service.IoAcceptor;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoService;
import org.apache.mina.core.service.TransportMetadata;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.session.IoSessionDataStructureFactory;
import org.apache.mina.filter.executor.ExecutorFilter;
import org.apache.mina.integration.beans.CollectionEditor;
import org.apache.mina.integration.beans.ListEditor;
import org.apache.mina.integration.beans.MapEditor;
import org.apache.mina.integration.beans.PropertyEditorFactory;
import org.apache.mina.integration.beans.SetEditor;
import org.apache.mina.integration.ognl.IoFilterPropertyAccessor;
import org.apache.mina.integration.ognl.IoServicePropertyAccessor;
import org.apache.mina.integration.ognl.IoSessionPropertyAccessor;
import org.apache.mina.integration.ognl.PropertyTypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectMBean<T>
implements ModelMBean,
MBeanRegistration {
    private static final Map<ObjectName, Object> sources = new ConcurrentHashMap<ObjectName, Object>();
    protected static final Logger LOGGER;
    private final T source;
    private final TransportMetadata transportMetadata;
    private final MBeanInfo info;
    private final Map<String, PropertyDescriptor> propertyDescriptors = new HashMap<String, PropertyDescriptor>();
    private final TypeConverter typeConverter = new OgnlTypeConverter();
    private volatile MBeanServer server;
    private volatile ObjectName name;

    public static Object getSource(ObjectName oname) {
        return sources.get(oname);
    }

    public ObjectMBean(T source) {
        if (source == null) {
            throw new IllegalArgumentException("source");
        }
        this.source = source;
        this.transportMetadata = source instanceof IoService ? ((IoService)source).getTransportMetadata() : (source instanceof IoSession ? ((IoSession)source).getTransportMetadata() : null);
        this.info = this.createModelMBeanInfo(source);
    }

    @Override
    public final Object getAttribute(String fqan) throws AttributeNotFoundException, MBeanException, ReflectionException {
        try {
            return this.convertValue(this.source.getClass(), fqan, this.getAttribute0(fqan), false);
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
        }
        catch (Exception e) {
            this.throwMBeanException(e);
        }
        PropertyDescriptor pdesc = this.propertyDescriptors.get(fqan);
        if (pdesc == null) {
            this.throwMBeanException(new IllegalArgumentException("Unknown attribute: " + fqan));
        }
        try {
            Object parent = this.getParent(fqan);
            boolean writable = this.isWritable(this.source.getClass(), pdesc);
            return this.convertValue(parent.getClass(), this.getLeafAttributeName(fqan), this.getAttribute(this.source, fqan, pdesc.getPropertyType()), writable);
        }
        catch (Exception e) {
            this.throwMBeanException(e);
            throw new IllegalStateException();
        }
    }

    @Override
    public final void setAttribute(Attribute attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        String aname = attribute.getName();
        Object avalue = attribute.getValue();
        try {
            this.setAttribute0(aname, avalue);
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
        }
        catch (Exception e) {
            this.throwMBeanException(e);
        }
        PropertyDescriptor pdesc = this.propertyDescriptors.get(aname);
        if (pdesc == null) {
            this.throwMBeanException(new IllegalArgumentException("Unknown attribute: " + aname));
        }
        try {
            PropertyEditor e = this.getPropertyEditor(this.getParent(aname).getClass(), pdesc.getName(), pdesc.getPropertyType());
            e.setAsText((String)avalue);
            OgnlContext ctx = (OgnlContext)Ognl.createDefaultContext(this.source);
            ctx.setTypeConverter(this.typeConverter);
            Ognl.setValue((String)aname, (Map)ctx, this.source, (Object)e.getValue());
        }
        catch (Exception e) {
            this.throwMBeanException(e);
        }
    }

    @Override
    public final Object invoke(String name, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (name.equals("unregisterMBean")) {
            try {
                this.server.unregisterMBean(this.name);
                return null;
            }
            catch (InstanceNotFoundException e) {
                this.throwMBeanException(e);
            }
        }
        try {
            return this.convertValue(null, null, this.invoke0(name, params, signature), false);
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            this.throwMBeanException(e);
        }
        Class[] paramTypes = new Class[signature.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            try {
                paramTypes[i] = this.getAttributeClass(signature[i]);
            }
            catch (ClassNotFoundException e) {
                this.throwMBeanException(e);
            }
            PropertyEditor e = this.getPropertyEditor(this.source.getClass(), "p" + i, paramTypes[i]);
            if (e == null) {
                this.throwMBeanException(new RuntimeException("Conversion failure: " + params[i]));
            }
            e.setValue(params[i]);
            params[i] = e.getAsText();
        }
        try {
            for (Method m : this.source.getClass().getMethods()) {
                Class<?>[] methodParamTypes;
                if (!m.getName().equalsIgnoreCase(name) || (methodParamTypes = m.getParameterTypes()).length != params.length) continue;
                Object[] convertedParams = new Object[params.length];
                for (int i = 0; i < params.length; ++i) {
                    if (Iterable.class.isAssignableFrom(methodParamTypes[i])) {
                        convertedParams = null;
                        break;
                    }
                    PropertyEditor e = this.getPropertyEditor(this.source.getClass(), "p" + i, methodParamTypes[i]);
                    if (e == null) {
                        convertedParams = null;
                        break;
                    }
                    e.setAsText((String)params[i]);
                    convertedParams[i] = e.getValue();
                }
                if (convertedParams == null) continue;
                return this.convertValue(m.getReturnType(), "returnValue", m.invoke(this.source, convertedParams), false);
            }
            throw new IllegalArgumentException("Failed to find a matching operation: " + name);
        }
        catch (Exception e) {
            this.throwMBeanException(e);
            throw new IllegalStateException();
        }
    }

    public final T getSource() {
        return this.source;
    }

    public final MBeanServer getServer() {
        return this.server;
    }

    public final ObjectName getName() {
        return this.name;
    }

    @Override
    public final MBeanInfo getMBeanInfo() {
        return this.info;
    }

    @Override
    public final AttributeList getAttributes(String[] names) {
        AttributeList answer = new AttributeList();
        for (int i = 0; i < names.length; ++i) {
            try {
                answer.add(new Attribute(names[i], this.getAttribute(names[i])));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return answer;
    }

    @Override
    public final AttributeList setAttributes(AttributeList attributes) {
        String[] names = new String[attributes.size()];
        int n = 0;
        for (Attribute item : attributes) {
            names[n++] = item.getName();
            try {
                this.setAttribute(item);
            }
            catch (Exception exception) {}
        }
        return this.getAttributes(names);
    }

    @Override
    public final void setManagedResource(Object resource, String type) throws InstanceNotFoundException, InvalidTargetObjectTypeException, MBeanException {
        throw new RuntimeOperationsException(new UnsupportedOperationException());
    }

    @Override
    public final void setModelMBeanInfo(ModelMBeanInfo info) throws MBeanException {
        throw new RuntimeOperationsException(new UnsupportedOperationException());
    }

    public final String toString() {
        return this.source == null ? "" : this.source.toString();
    }

    @Override
    public void addAttributeChangeNotificationListener(NotificationListener listener, String name, Object handback) {
    }

    @Override
    public void removeAttributeChangeNotificationListener(NotificationListener listener, String name) throws ListenerNotFoundException {
    }

    @Override
    public void sendAttributeChangeNotification(AttributeChangeNotification notification) throws MBeanException {
        throw new RuntimeOperationsException(new UnsupportedOperationException());
    }

    @Override
    public void sendAttributeChangeNotification(Attribute oldValue, Attribute newValue) throws MBeanException {
        throw new RuntimeOperationsException(new UnsupportedOperationException());
    }

    @Override
    public void sendNotification(Notification notification) throws MBeanException {
        throw new RuntimeOperationsException(new UnsupportedOperationException());
    }

    @Override
    public void sendNotification(String message) throws MBeanException {
        throw new RuntimeOperationsException(new UnsupportedOperationException());
    }

    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[0];
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
    }

    @Override
    public void load() throws InstanceNotFoundException, MBeanException, RuntimeOperationsException {
        throw new RuntimeOperationsException(new UnsupportedOperationException());
    }

    @Override
    public void store() throws InstanceNotFoundException, MBeanException, RuntimeOperationsException {
        throw new RuntimeOperationsException(new UnsupportedOperationException());
    }

    @Override
    public final ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        this.name = name;
        return name;
    }

    @Override
    public final void postRegister(Boolean registrationDone) {
        if (registrationDone.booleanValue()) {
            sources.put(this.name, this.source);
        }
    }

    @Override
    public final void preDeregister() throws Exception {
    }

    @Override
    public final void postDeregister() {
        sources.remove(this.name);
        this.server = null;
        this.name = null;
    }

    private MBeanInfo createModelMBeanInfo(T source) {
        String className = source.getClass().getName();
        String description = "";
        ModelMBeanConstructorInfo[] constructors = new ModelMBeanConstructorInfo[]{};
        ModelMBeanNotificationInfo[] notifications = new ModelMBeanNotificationInfo[]{};
        ArrayList<ModelMBeanAttributeInfo> attributes = new ArrayList<ModelMBeanAttributeInfo>();
        ArrayList<ModelMBeanOperationInfo> operations = new ArrayList<ModelMBeanOperationInfo>();
        this.addAttributes(attributes, source);
        this.addExtraAttributes(attributes);
        this.addOperations(operations, source);
        this.addExtraOperations(operations);
        operations.add(new ModelMBeanOperationInfo("unregisterMBean", "unregisterMBean", new MBeanParameterInfo[0], Void.TYPE.getName(), 1));
        return new ModelMBeanInfoSupport(className, description, attributes.toArray(new ModelMBeanAttributeInfo[attributes.size()]), constructors, operations.toArray(new ModelMBeanOperationInfo[operations.size()]), notifications);
    }

    private void addAttributes(List<ModelMBeanAttributeInfo> attributes, Object object) {
        this.addAttributes(attributes, object, object.getClass(), "");
    }

    private void addAttributes(List<ModelMBeanAttributeInfo> attributes, Object object, Class<?> type, String prefix) {
        PropertyDescriptor[] pdescs;
        try {
            pdescs = Introspector.getBeanInfo(type).getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            return;
        }
        for (PropertyDescriptor pdesc : pdescs) {
            if (pdesc.getReadMethod() == null) continue;
            String attrName = pdesc.getName();
            Class<?> attrType = pdesc.getPropertyType();
            if (attrName.equals("class") || !this.isReadable(type, attrName)) continue;
            if (this.isExpandable(type, attrName)) {
                this.expandAttribute(attributes, object, prefix, pdesc);
                continue;
            }
            String fqan = prefix + attrName;
            boolean writable = this.isWritable(type, pdesc);
            attributes.add(new ModelMBeanAttributeInfo(fqan, this.convertType(object.getClass(), attrName, attrType, writable).getName(), pdesc.getShortDescription(), true, writable, false));
            this.propertyDescriptors.put(fqan, pdesc);
        }
    }

    private boolean isWritable(Class<?> type, PropertyDescriptor pdesc) {
        boolean writable;
        if (type == null) {
            throw new IllegalArgumentException("type");
        }
        if (pdesc == null) {
            return false;
        }
        String attrName = pdesc.getName();
        Class<?> attrType = pdesc.getPropertyType();
        boolean bl = writable = pdesc.getWriteMethod() != null || this.isWritable(type, attrName);
        if (this.getPropertyEditor(type, attrName, attrType) == null) {
            writable = false;
        }
        return writable;
    }

    private void expandAttribute(List<ModelMBeanAttributeInfo> attributes, Object object, String prefix, PropertyDescriptor pdesc) {
        Object property;
        String attrName = pdesc.getName();
        try {
            property = this.getAttribute(object, attrName, pdesc.getPropertyType());
        }
        catch (Exception e) {
            LOGGER.debug("Unexpected exception.", (Throwable)e);
            return;
        }
        if (property == null) {
            return;
        }
        this.addAttributes(attributes, property, property.getClass(), prefix + attrName + '.');
    }

    private void addOperations(List<ModelMBeanOperationInfo> operations, Object object) {
        for (Method m : object.getClass().getMethods()) {
            String mname = m.getName();
            if (mname.startsWith("is") || mname.startsWith("get") || mname.startsWith("set") || mname.matches("(wait|notify|notifyAll|toString|equals|compareTo|hashCode|clone)") || !this.isOperation(mname, m.getParameterTypes())) continue;
            ArrayList<MBeanParameterInfo> signature = new ArrayList<MBeanParameterInfo>();
            int i = 1;
            for (Class<?> paramType : m.getParameterTypes()) {
                String paramName = "p" + i++;
                if (this.getPropertyEditor(this.source.getClass(), paramName, paramType) == null) continue;
                signature.add(new MBeanParameterInfo(paramName, this.convertType(null, null, paramType, true).getName(), paramName));
            }
            Class<?> returnType = this.convertType(null, null, m.getReturnType(), false);
            operations.add(new ModelMBeanOperationInfo(m.getName(), m.getName(), signature.toArray(new MBeanParameterInfo[signature.size()]), returnType.getName(), 1));
        }
    }

    private Object getParent(String fqan) throws OgnlException {
        int dotIndex = fqan.lastIndexOf(46);
        Object parent = dotIndex < 0 ? this.source : this.getAttribute(this.source, fqan.substring(0, dotIndex), null);
        return parent;
    }

    private String getLeafAttributeName(String fqan) {
        int dotIndex = fqan.lastIndexOf(46);
        if (dotIndex < 0) {
            return fqan;
        }
        return fqan.substring(dotIndex + 1);
    }

    private Class<?> getAttributeClass(String signature) throws ClassNotFoundException {
        if (signature.equals(Boolean.TYPE.getName())) {
            return Boolean.TYPE;
        }
        if (signature.equals(Byte.TYPE.getName())) {
            return Byte.TYPE;
        }
        if (signature.equals(Character.TYPE.getName())) {
            return Character.TYPE;
        }
        if (signature.equals(Double.TYPE.getName())) {
            return Double.TYPE;
        }
        if (signature.equals(Float.TYPE.getName())) {
            return Float.TYPE;
        }
        if (signature.equals(Integer.TYPE.getName())) {
            return Integer.TYPE;
        }
        if (signature.equals(Long.TYPE.getName())) {
            return Long.TYPE;
        }
        if (signature.equals(Short.TYPE.getName())) {
            return Short.TYPE;
        }
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl != null) {
                return cl.loadClass(signature);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return Class.forName(signature);
    }

    private Object getAttribute(Object object, String fqan, Class<?> attrType) throws OgnlException {
        OgnlContext ctx = (OgnlContext)Ognl.createDefaultContext((Object)object);
        ctx.setTypeConverter((TypeConverter)new OgnlTypeConverter());
        Object property = attrType == null ? Ognl.getValue((String)fqan, (Map)ctx, (Object)object) : Ognl.getValue((String)fqan, (Map)ctx, (Object)object, attrType);
        return property;
    }

    private Class<?> convertType(Class<?> type, String attrName, Class<?> attrType, boolean writable) {
        if (attrName != null && (attrType == Long.class || attrType == Long.TYPE) && attrName.endsWith("Time") && attrName.indexOf("Total") < 0 && attrName.indexOf("Min") < 0 && attrName.indexOf("Max") < 0 && attrName.indexOf("Avg") < 0 && attrName.indexOf("Average") < 0 && !this.propertyDescriptors.containsKey(attrName + "InMillis")) {
            return Date.class;
        }
        if (IoFilterChain.class.isAssignableFrom(attrType)) {
            return Map.class;
        }
        if (IoFilterChainBuilder.class.isAssignableFrom(attrType)) {
            return Map.class;
        }
        if (!writable) {
            if (Collection.class.isAssignableFrom(attrType) || Map.class.isAssignableFrom(attrType)) {
                if (List.class.isAssignableFrom(attrType)) {
                    return List.class;
                }
                if (Set.class.isAssignableFrom(attrType)) {
                    return Set.class;
                }
                if (Map.class.isAssignableFrom(attrType)) {
                    return Map.class;
                }
                return Collection.class;
            }
            if ((attrType.isPrimitive() || Date.class.isAssignableFrom(attrType) || Boolean.class.isAssignableFrom(attrType) || Character.class.isAssignableFrom(attrType) || Number.class.isAssignableFrom(attrType)) && (attrName == null || !attrName.endsWith("InMillis") || !this.propertyDescriptors.containsKey(attrName.substring(0, attrName.length() - 8)))) {
                return attrType;
            }
        }
        return String.class;
    }

    private Object convertValue(Class<?> type, String attrName, Object v, boolean writable) {
        PropertyEditor editor;
        if (v == null) {
            return null;
        }
        if (attrName != null && v instanceof Long && attrName.endsWith("Time") && attrName.indexOf("Total") < 0 && attrName.indexOf("Min") < 0 && attrName.indexOf("Max") < 0 && attrName.indexOf("Avg") < 0 && attrName.indexOf("Average") < 0 && !this.propertyDescriptors.containsKey(attrName + "InMillis")) {
            long time = (Long)v;
            if (time <= 0L) {
                return null;
            }
            return new Date((Long)v);
        }
        if (v instanceof IoSessionDataStructureFactory || v instanceof IoHandler) {
            return v.getClass().getName();
        }
        if (v instanceof IoFilterChainBuilder) {
            LinkedHashMap<String, String> filterMapping = new LinkedHashMap<String, String>();
            if (v instanceof DefaultIoFilterChainBuilder) {
                for (IoFilterChain.Entry e : ((DefaultIoFilterChainBuilder)v).getAll()) {
                    filterMapping.put(e.getName(), e.getFilter().getClass().getName());
                }
            } else {
                filterMapping.put("Unknown builder type", v.getClass().getName());
            }
            return filterMapping;
        }
        if (v instanceof IoFilterChain) {
            LinkedHashMap<String, String> filterMapping = new LinkedHashMap<String, String>();
            for (IoFilterChain.Entry e : ((IoFilterChain)v).getAll()) {
                filterMapping.put(e.getName(), e.getFilter().getClass().getName());
            }
            return filterMapping;
        }
        if (!writable) {
            if (v instanceof Collection || v instanceof Map) {
                if (v instanceof List) {
                    return this.convertCollection(v, new ArrayList<Object>());
                }
                if (v instanceof Set) {
                    return this.convertCollection(v, new LinkedHashSet<Object>());
                }
                if (v instanceof Map) {
                    return this.convertCollection(v, new LinkedHashMap<Object, Object>());
                }
                return this.convertCollection(v, new ArrayList<Object>());
            }
            if ((v instanceof Date || v instanceof Boolean || v instanceof Character || v instanceof Number) && (attrName == null || !attrName.endsWith("InMillis") || !this.propertyDescriptors.containsKey(attrName.substring(0, attrName.length() - 8)))) {
                return v;
            }
        }
        if ((editor = this.getPropertyEditor(type, attrName, v.getClass())) != null) {
            editor.setValue(v);
            return editor.getAsText();
        }
        return v.toString();
    }

    private Object convertCollection(Object src, Collection<Object> dst) {
        Collection srcCol = (Collection)src;
        for (Object e : srcCol) {
            Object convertedValue = this.convertValue(dst.getClass(), "element", e, false);
            if (e != null && convertedValue == null) {
                convertedValue = e.toString();
            }
            dst.add(convertedValue);
        }
        return dst;
    }

    private Object convertCollection(Object src, Map<Object, Object> dst) {
        Map srcCol = (Map)src;
        for (Map.Entry e : srcCol.entrySet()) {
            Object convertedKey = this.convertValue(dst.getClass(), "key", e.getKey(), false);
            Object convertedValue = this.convertValue(dst.getClass(), "value", e.getValue(), false);
            if (e.getKey() != null && convertedKey == null) {
                convertedKey = e.getKey().toString();
            }
            if (e.getValue() != null && convertedValue == null) {
                convertedKey = e.getValue().toString();
            }
            dst.put(convertedKey, convertedValue);
        }
        return dst;
    }

    private void throwMBeanException(Throwable e) throws MBeanException {
        if (e instanceof OgnlException) {
            OgnlException ognle = (OgnlException)e;
            if (ognle.getReason() != null) {
                this.throwMBeanException(ognle.getReason());
            } else {
                String message = ognle.getMessage();
                if (e instanceof NoSuchPropertyException) {
                    message = "No such property: " + message;
                } else if (e instanceof ExpressionSyntaxException) {
                    message = "Illegal expression syntax: " + message;
                } else if (e instanceof InappropriateExpressionException) {
                    message = "Inappropriate expression: " + message;
                }
                e = new IllegalArgumentException(message);
                e.setStackTrace(ognle.getStackTrace());
            }
        }
        if (e instanceof InvocationTargetException) {
            this.throwMBeanException(e.getCause());
        }
        LOGGER.warn("Unexpected exception.", e);
        if (e.getClass().getPackage().getName().matches("javax?\\..+")) {
            if (e instanceof Exception) {
                throw new MBeanException((Exception)e, e.getMessage());
            }
            throw new MBeanException(new RuntimeException(e), e.getMessage());
        }
        throw new MBeanException(new RuntimeException(e.getClass().getName() + ": " + e.getMessage()), e.getMessage());
    }

    protected Object getAttribute0(String fqan) throws Exception {
        throw new AttributeNotFoundException(fqan);
    }

    protected void setAttribute0(String attrName, Object attrValue) throws Exception {
        throw new AttributeNotFoundException(attrName);
    }

    protected Object invoke0(String name, Object[] params, String[] signature) throws Exception {
        throw new NoSuchMethodException();
    }

    protected boolean isReadable(Class<?> type, String attrName) {
        if (IoService.class.isAssignableFrom(type) && attrName.equals("filterChain")) {
            return false;
        }
        if (IoService.class.isAssignableFrom(type) && attrName.equals("localAddress")) {
            return false;
        }
        if (IoService.class.isAssignableFrom(type) && attrName.equals("defaultLocalAddress")) {
            return false;
        }
        if (IoSession.class.isAssignableFrom(type) && attrName.equals("attachment")) {
            return false;
        }
        if (IoSession.class.isAssignableFrom(type) && attrName.equals("attributeKeys")) {
            return false;
        }
        if (IoSession.class.isAssignableFrom(type) && attrName.equals("closeFuture")) {
            return false;
        }
        return !ThreadPoolExecutor.class.isAssignableFrom(type) || !attrName.equals("queue");
    }

    protected boolean isWritable(Class<?> type, String attrName) {
        return IoService.class.isAssignableFrom(type) && attrName.startsWith("defaultLocalAddress");
    }

    protected Class<?> getElementType(Class<?> type, String attrName) {
        if (this.transportMetadata != null && IoAcceptor.class.isAssignableFrom(type) && "defaultLocalAddresses".equals(attrName)) {
            return this.transportMetadata.getAddressType();
        }
        return String.class;
    }

    protected Class<?> getMapKeyType(Class<?> type, String attrName) {
        return String.class;
    }

    protected Class<?> getMapValueType(Class<?> type, String attrName) {
        return String.class;
    }

    protected boolean isExpandable(Class<?> type, String attrName) {
        if (IoService.class.isAssignableFrom(type) && (attrName.equals("statistics") || attrName.equals("sessionConfig") || attrName.equals("transportMetadata") || attrName.equals("config") || attrName.equals("transportMetadata"))) {
            return true;
        }
        if (ExecutorFilter.class.isAssignableFrom(type) && attrName.equals("executor")) {
            return true;
        }
        return ThreadPoolExecutor.class.isAssignableFrom(type) && attrName.equals("queueHandler");
    }

    protected boolean isOperation(String methodName, Class<?>[] paramTypes) {
        return true;
    }

    protected void addExtraAttributes(List<ModelMBeanAttributeInfo> attributes) {
    }

    protected void addExtraOperations(List<ModelMBeanOperationInfo> operations) {
    }

    protected PropertyEditor getPropertyEditor(Class<?> type, String attrName, Class<?> attrType) {
        if (type == null) {
            throw new IllegalArgumentException("type");
        }
        if (attrName == null) {
            throw new IllegalArgumentException("attrName");
        }
        if (this.transportMetadata != null && attrType == SocketAddress.class) {
            attrType = this.transportMetadata.getAddressType();
        }
        if (attrType == Long.class || attrType == Long.TYPE) {
            if (attrName.endsWith("Time") && attrName.indexOf("Total") < 0 && attrName.indexOf("Min") < 0 && attrName.indexOf("Max") < 0 && attrName.indexOf("Avg") < 0 && attrName.indexOf("Average") < 0 && !this.propertyDescriptors.containsKey(attrName + "InMillis")) {
                return PropertyEditorFactory.getInstance(Date.class);
            }
            if (attrName.equals("id")) {
                return PropertyEditorFactory.getInstance(String.class);
            }
        }
        if (List.class.isAssignableFrom(attrType)) {
            return new ListEditor(this.getElementType(type, attrName));
        }
        if (Set.class.isAssignableFrom(attrType)) {
            return new SetEditor(this.getElementType(type, attrName));
        }
        if (Collection.class.isAssignableFrom(attrType)) {
            return new CollectionEditor(this.getElementType(type, attrName));
        }
        if (Map.class.isAssignableFrom(attrType)) {
            return new MapEditor(this.getMapKeyType(type, attrName), this.getMapValueType(type, attrName));
        }
        return PropertyEditorFactory.getInstance((Class)attrType);
    }

    static {
        OgnlRuntime.setPropertyAccessor(IoService.class, (PropertyAccessor)new IoServicePropertyAccessor());
        OgnlRuntime.setPropertyAccessor(IoSession.class, (PropertyAccessor)new IoSessionPropertyAccessor());
        OgnlRuntime.setPropertyAccessor(IoFilter.class, (PropertyAccessor)new IoFilterPropertyAccessor());
        LOGGER = LoggerFactory.getLogger(ObjectMBean.class);
    }

    private class OgnlTypeConverter
    extends PropertyTypeConverter {
        private OgnlTypeConverter() {
        }

        protected PropertyEditor getPropertyEditor(Class<?> type, String attrName, Class<?> attrType) {
            return ObjectMBean.this.getPropertyEditor(type, attrName, attrType);
        }
    }
}

