/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.http;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.mina.http.api.HttpMethod;
import org.apache.mina.http.api.HttpRequest;
import org.apache.mina.http.api.HttpVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRequestImpl
implements HttpRequest {
    private final HttpVersion version;
    private final HttpMethod method;
    private final String requestedPath;
    private final String queryString;
    private final Map<String, String> headers;

    public HttpRequestImpl(HttpVersion version, HttpMethod method, String requestedPath, String queryString, Map<String, String> headers) {
        this.version = version;
        this.method = method;
        this.requestedPath = requestedPath;
        this.queryString = queryString;
        this.headers = headers;
    }

    @Override
    public HttpVersion getProtocolVersion() {
        return this.version;
    }

    @Override
    public String getContentType() {
        return this.headers.get("content-type");
    }

    @Override
    public boolean isKeepAlive() {
        return false;
    }

    @Override
    public String getHeader(String name) {
        return this.headers.get(name);
    }

    @Override
    public boolean containsHeader(String name) {
        return this.headers.containsKey(name);
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public boolean containsParameter(String name) {
        Matcher m = this.parameterPattern(name);
        return m.find();
    }

    @Override
    public String getParameter(String name) {
        Matcher m = this.parameterPattern(name);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    protected Matcher parameterPattern(String name) {
        return Pattern.compile("[&]" + name + "=([^&]*)").matcher("&" + this.queryString);
    }

    @Override
    public Map<String, List<String>> getParameters() {
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        String[] params = this.queryString.split("&");
        if (params.length == 1) {
            return parameters;
        }
        for (int i = 0; i < params.length; ++i) {
            String value;
            String[] param = params[i].split("=");
            String name = param[0];
            String string = value = param.length == 2 ? param[1] : "";
            if (!parameters.containsKey(name)) {
                parameters.put(name, new ArrayList());
            }
            ((List)parameters.get(name)).add(value);
        }
        return parameters;
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }

    @Override
    public HttpMethod getMethod() {
        return this.method;
    }

    @Override
    public String getRequestPath() {
        return this.requestedPath;
    }

    public String toString() {
        String result = "HTTP REQUEST METHOD: " + (Object)((Object)this.method) + "\n";
        result = result + "VERSION: " + (Object)((Object)this.version) + "\n";
        result = result + "PATH: " + this.requestedPath + "\n";
        result = result + "QUERY:" + this.queryString + "\n";
        result = result + "--- HEADER --- \n";
        for (String key : this.headers.keySet()) {
            String value = this.headers.get(key);
            result = result + key + ":" + value + "\n";
        }
        result = result + "--- PARAMETERS --- \n";
        Map<String, List<String>> parameters = this.getParameters();
        for (String key : parameters.keySet()) {
            Collection values = parameters.get(key);
            for (String value : values) {
                result = result + key + ":" + value + "\n";
            }
        }
        return result;
    }
}

