/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.http;

import java.nio.ByteBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.apache.mina.http.HttpClientCodec;
import org.apache.mina.http.api.HttpEndOfContent;
import org.apache.mina.http.api.HttpRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientEncoder
implements ProtocolEncoder {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientCodec.class);
    private static final CharsetEncoder ENCODER = StandardCharsets.UTF_8.newEncoder();

    public void encode(IoSession session, Object message, ProtocolEncoderOutput out) throws Exception {
        LOG.debug("encode {}", (Object)message.getClass().getCanonicalName());
        if (message instanceof HttpRequest) {
            LOG.debug("HttpRequest");
            HttpRequest msg = (HttpRequest)message;
            StringBuilder sb = new StringBuilder(msg.getMethod().toString());
            sb.append(" ");
            sb.append(msg.getRequestPath());
            if (!"".equals(msg.getQueryString())) {
                sb.append("?");
                sb.append(msg.getQueryString());
            }
            sb.append(" ");
            sb.append((Object)msg.getProtocolVersion());
            sb.append("\r\n");
            for (Map.Entry<String, String> header : msg.getHeaders().entrySet()) {
                sb.append(header.getKey());
                sb.append(": ");
                sb.append(header.getValue());
                sb.append("\r\n");
            }
            sb.append("\r\n");
            IoBuffer buf = IoBuffer.allocate((int)sb.length()).setAutoExpand(true);
            buf.putString((CharSequence)sb.toString(), ENCODER);
            buf.flip();
            out.write((Object)buf);
        } else if (message instanceof ByteBuffer) {
            LOG.debug("Body");
            out.write(message);
        } else if (message instanceof HttpEndOfContent) {
            LOG.debug("End of Content");
        }
    }

    public void dispose(IoSession arg0) throws Exception {
    }
}

