/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.http;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.mina.http.api.HttpMethod;
import org.apache.mina.http.api.HttpRequest;
import org.apache.mina.http.api.HttpVersion;

public class HttpRequestImpl
implements HttpRequest {
    private final HttpVersion version;
    private final HttpMethod method;
    private final String requestedPath;
    private final String queryString;
    private final Map<String, String> headers;

    public HttpRequestImpl(HttpVersion version, HttpMethod method, String requestedPath, String queryString, Map<String, String> headers) {
        this.version = version;
        this.method = method;
        this.requestedPath = requestedPath;
        this.queryString = queryString;
        this.headers = headers;
    }

    @Override
    public HttpVersion getProtocolVersion() {
        return this.version;
    }

    @Override
    public String getContentType() {
        return this.headers.get("content-type");
    }

    @Override
    public boolean isKeepAlive() {
        return false;
    }

    @Override
    public String getHeader(String name) {
        return this.headers.get(name);
    }

    @Override
    public boolean containsHeader(String name) {
        return this.headers.containsKey(name);
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public boolean containsParameter(String name) {
        Matcher m = this.parameterPattern(name);
        return m.find();
    }

    @Override
    public String getParameter(String name) {
        Matcher m = this.parameterPattern(name);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    protected Matcher parameterPattern(String name) {
        return Pattern.compile("[&]" + name + "=([^&]*)").matcher("&" + this.queryString);
    }

    @Override
    public Map<String, List<String>> getParameters() {
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        String[] params = this.queryString.split("&");
        if (params.length == 1) {
            return parameters;
        }
        for (int i = 0; i < params.length; ++i) {
            String value;
            String[] param = params[i].split("=");
            String name = param[0];
            String string = value = param.length == 2 ? param[1] : "";
            if (!parameters.containsKey(name)) {
                parameters.put(name, new ArrayList());
            }
            ((List)parameters.get(name)).add(value);
        }
        return parameters;
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }

    @Override
    public HttpMethod getMethod() {
        return this.method;
    }

    @Override
    public String getRequestPath() {
        return this.requestedPath;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HTTP REQUEST METHOD: ").append((Object)this.method).append('\n');
        sb.append("VERSION: ").append((Object)this.version).append('\n');
        sb.append("PATH: ").append(this.requestedPath).append('\n');
        sb.append("QUERY:").append(this.queryString).append('\n');
        sb.append("--- HEADER --- \n");
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            sb.append(entry.getKey()).append(':').append(entry.getValue()).append('\n');
        }
        sb.append("--- PARAMETERS --- \n");
        Map<String, List<String>> parameters = this.getParameters();
        for (Map.Entry<String, List<String>> entry : parameters.entrySet()) {
            String key = entry.getKey();
            for (String value : entry.getValue()) {
                sb.append(key).append(':').append(value).append('\n');
            }
        }
        return sb.toString();
    }
}

