/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.examples.coap;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.Random;
import org.apache.mina.coap.CoapCode;
import org.apache.mina.coap.CoapMessage;
import org.apache.mina.coap.CoapOption;
import org.apache.mina.coap.CoapOptionType;
import org.apache.mina.coap.MessageType;
import org.apache.mina.coap.codec.CoapDecoder;
import org.apache.mina.coap.codec.CoapEncoder;

public class BlockingGetClient {
    public static void main(String[] args) {
        try {
            DatagramChannel channel = DatagramChannel.open();
            InetSocketAddress target = new InetSocketAddress("127.0.0.1", 5683);
            channel.connect(target);
            System.err.println(channel);
            CoapEncoder encoder = new CoapEncoder();
            CoapDecoder decoder = new CoapDecoder();
            ByteBuffer buff = ByteBuffer.allocateDirect(2048);
            Random r = new Random();
            byte[] url = "nlp".getBytes();
            CoapMessage msg = new CoapMessage(1, MessageType.CONFIRMABLE, CoapCode.GET.getCode(), 1234, null, new CoapOption[]{new CoapOption(CoapOptionType.URI_PATH, url)}, null);
            for (int j = 0; j < 8; ++j) {
                long start = System.currentTimeMillis();
                int count = 100000;
                for (int i = 0; i < 100000; ++i) {
                    buff.position(0);
                    buff.limit(buff.capacity());
                    int id = r.nextInt(1024);
                    msg.setId(id);
                    int bytes = channel.send(encoder.encode(msg, null), target);
                    if (bytes < 1) {
                        System.err.println("write fail :/ " + bytes);
                        continue;
                    }
                    buff.position(0);
                    buff.limit(buff.capacity());
                    SocketAddress addy = channel.receive(buff);
                    buff.flip();
                    CoapMessage response = decoder.decode(buff, null);
                    if (response.getId() == id) continue;
                    System.err.println("gni?");
                }
                System.err.println("time : " + (System.currentTimeMillis() - start) + "ms");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

