/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.tcp.perf;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.GeneralSecurityException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.mina.core.filterchain.DefaultIoFilterChainBuilder;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.example.echoserver.ssl.BogusSSLContextFactory;
import org.apache.mina.filter.ssl.SslFilter;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;

public class TcpSslServer
extends IoHandlerAdapter {
    public static final int PORT = 18567;
    public static final int MAX_RECEIVED = 100000;
    private static long t0;
    private AtomicInteger nbReceived = new AtomicInteger(0);

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        cause.printStackTrace();
        session.closeNow();
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        int nb = this.nbReceived.incrementAndGet();
        if (nb == 1) {
            t0 = System.currentTimeMillis();
        }
        if (nb == 100000) {
            long t1 = System.currentTimeMillis();
            System.out.println("-------------> end " + (t1 - t0));
        }
        if (nb % 10000 == 0) {
            System.out.println("Received " + nb + " messages");
        }
        session.write(message);
    }

    public void sessionClosed(IoSession session) throws Exception {
        System.out.println("Session closed...");
        System.out.println("Nb message received : " + this.nbReceived.get());
        this.nbReceived.set(0);
    }

    public void sessionCreated(IoSession session) throws Exception {
        System.out.println("Session created...");
    }

    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
        System.out.println("Session idle...");
    }

    public void sessionOpened(IoSession session) throws Exception {
        System.out.println("Session Opened...");
    }

    public TcpSslServer() throws IOException, GeneralSecurityException {
        NioSocketAcceptor acceptor = new NioSocketAcceptor();
        DefaultIoFilterChainBuilder chain = acceptor.getFilterChain();
        SslFilter sslFilter = new SslFilter(BogusSSLContextFactory.getInstance(true));
        chain.addLast("sslFilter", (IoFilter)sslFilter);
        acceptor.setHandler((IoHandler)this);
        acceptor.bind((SocketAddress)new InetSocketAddress(18567));
        System.out.println("Server started...");
    }

    public static void main(String[] args) throws Exception {
        new TcpSslServer();
    }
}

