/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.echoserver;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.mina.core.filterchain.DefaultIoFilterChainBuilder;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.example.echoserver.EchoProtocolHandler;
import org.apache.mina.example.echoserver.ssl.BogusSSLContextFactory;
import org.apache.mina.filter.compression.CompressionFilter;
import org.apache.mina.filter.ssl.SslFilter;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;

public class Main {
    private static final int PORT = 8080;
    private static final boolean USE_SSL = false;

    public static void main(String[] args) throws Exception {
        NioSocketAcceptor acceptor = new NioSocketAcceptor();
        acceptor.setReuseAddress(true);
        DefaultIoFilterChainBuilder chain = acceptor.getFilterChain();
        chain.addLast("Compressor", (IoFilter)new CompressionFilter());
        acceptor.setHandler((IoHandler)new EchoProtocolHandler());
        acceptor.bind((SocketAddress)new InetSocketAddress(8080));
        System.out.println("Listening on port 8080");
        while (true) {
            System.out.println("R: " + acceptor.getStatistics().getReadBytesThroughput() + ", W: " + acceptor.getStatistics().getWrittenBytesThroughput());
            Thread.sleep(3000L);
        }
    }

    private static void addSSLSupport(DefaultIoFilterChainBuilder chain) throws Exception {
        SslFilter sslFilter = new SslFilter(BogusSSLContextFactory.getInstance(true));
        chain.addLast("sslFilter", (IoFilter)sslFilter);
        System.out.println("SSL ON");
    }
}

