/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.echoserver;

import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EchoProtocolHandler
extends IoHandlerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(EchoProtocolHandler.class);

    public void sessionCreated(IoSession session) {
        session.getConfig().setIdleTime(IdleStatus.BOTH_IDLE, 10);
    }

    public void sessionClosed(IoSession session) throws Exception {
        LOGGER.info("CLOSED");
    }

    public void sessionOpened(IoSession session) throws Exception {
        LOGGER.info("OPENED");
    }

    public void sessionIdle(IoSession session, IdleStatus status) {
        LOGGER.info("*** IDLE #" + session.getIdleCount(IdleStatus.BOTH_IDLE) + " ***");
    }

    public void exceptionCaught(IoSession session, Throwable cause) {
        session.closeNow();
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        LOGGER.info("Received : " + message);
        session.write((Object)((IoBuffer)message).duplicate());
    }
}

