/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.haiku;

import org.apache.mina.example.haiku.Haiku;
import org.apache.mina.example.haiku.InvalidHaikuException;
import org.apache.mina.example.haiku.PhraseUtilities;

public class HaikuValidator {
    private static final int[] SYLLABLE_COUNTS = new int[]{5, 7, 5};

    public void validate(Haiku haiku) throws InvalidHaikuException {
        String[] phrases = haiku.getPhrases();
        for (int i = 0; i < phrases.length; ++i) {
            String phrase = phrases[i];
            int count = PhraseUtilities.countSyllablesInPhrase(phrase);
            if (count == SYLLABLE_COUNTS[i]) continue;
            throw new InvalidHaikuException(i + 1, phrase, count, SYLLABLE_COUNTS[i]);
        }
    }
}

