/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.tapedeck;

import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.apache.mina.example.tapedeck.Command;
import org.apache.mina.example.tapedeck.CommandSyntaxException;
import org.apache.mina.example.tapedeck.PasswordCommand;
import org.apache.mina.example.tapedeck.QuitCommand;
import org.apache.mina.example.tapedeck.TapeDeckServer;
import org.apache.mina.example.tapedeck.UserCommand;
import org.apache.mina.statemachine.StateControl;
import org.apache.mina.statemachine.annotation.IoFilterTransition;
import org.apache.mina.statemachine.annotation.State;
import org.apache.mina.statemachine.context.AbstractStateContext;
import org.apache.mina.statemachine.event.IoFilterEvents;

public class AuthenticationHandler {
    @State
    public static final String ROOT = "Root";
    @State(value="Root")
    public static final String START = "Start";
    @State(value="Root")
    public static final String WAIT_USER = "WaitUser";
    @State(value="Root")
    public static final String WAIT_PASSWORD = "WaitPassword";
    @State(value="Root")
    public static final String DONE = "Done";
    @State(value="Root")
    public static final String FAILED = "Failed";

    @IoFilterTransition(on={IoFilterEvents.SESSION_OPENED}, in={"Start"}, next="WaitUser")
    public void sendAuthRequest(IoFilter.NextFilter nextFilter, IoSession session) {
        session.write((Object)"+ Greetings from your tape deck!. Please authenticate yourself.");
    }

    @IoFilterTransition(on={IoFilterEvents.MESSAGE_RECEIVED}, in={"WaitUser"}, next="WaitPassword")
    public void user(AuthenticationContext context, IoFilter.NextFilter nextFilter, IoSession session, UserCommand cmd) {
        context.user = cmd.getUsername();
        session.write((Object)"+ Give me your password (hint: try your username backwards)");
    }

    @IoFilterTransition(on={IoFilterEvents.MESSAGE_RECEIVED}, in={"WaitPassword"}, next="Done")
    public void password(AuthenticationContext context, IoFilter.NextFilter nextFilter, IoSession session, PasswordCommand cmd) {
        context.password = cmd.getPassword();
        if (context.password.equals(this.reverse(context.user))) {
            session.write((Object)"+ Authentication succeeded! Your tape deck has been unlocked.");
        } else {
            context.tries++;
            if (context.tries < 3) {
                session.write((Object)"- Authentication failed! Please try again.");
                StateControl.breakAndGotoNext((String)WAIT_USER);
            } else {
                session.write((Object)"- Authentication failed too many times! Bye bye.").addListener(IoFutureListener.CLOSE);
                StateControl.breakAndGotoNext((String)FAILED);
            }
        }
    }

    @IoFilterTransition(on={IoFilterEvents.MESSAGE_RECEIVED}, in={"Root"})
    public void quit(TapeDeckServer.TapeDeckContext context, IoSession session, QuitCommand cmd) {
        session.write((Object)"+ Bye! Please come back!").addListener(IoFutureListener.CLOSE);
    }

    private String reverse(String s) {
        char[] expectedPassword = new char[s.length()];
        for (int i = 0; i < expectedPassword.length; ++i) {
            expectedPassword[i] = s.charAt(s.length() - i - 1);
        }
        return new String(expectedPassword);
    }

    @IoFilterTransition(on={IoFilterEvents.MESSAGE_RECEIVED}, in={"WaitUser"}, weight=10)
    public void errorWaitingForUser(IoSession session, Command cmd) {
        if (cmd instanceof QuitCommand) {
            StateControl.breakAndContinue();
        }
        session.write((Object)("Unexpected command '" + cmd.getName() + "'. Expected 'user <username>'."));
    }

    @IoFilterTransition(on={IoFilterEvents.MESSAGE_RECEIVED}, in={"WaitPassword"}, weight=10)
    public void errorWaitingForPassword(IoSession session, Command cmd) {
        if (cmd instanceof QuitCommand) {
            StateControl.breakAndContinue();
        }
        session.write((Object)("Unexpected command '" + cmd.getName() + "'. Expected 'password <password>'."));
    }

    @IoFilterTransition(on={IoFilterEvents.EXCEPTION_CAUGHT}, in={"Root"})
    public void commandSyntaxError(IoSession session, CommandSyntaxException e) {
        session.write((Object)("- " + e.getMessage()));
    }

    @IoFilterTransition(on={IoFilterEvents.EXCEPTION_CAUGHT}, in={"Root"}, weight=10)
    public void exceptionCaught(IoSession session, Exception e) {
        e.printStackTrace();
        session.closeNow();
    }

    @IoFilterTransition(on={IoFilterEvents.SESSION_CLOSED}, in={"Done"})
    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) {
        nextFilter.sessionClosed(session);
    }

    @IoFilterTransition(on={IoFilterEvents.EXCEPTION_CAUGHT}, in={"Done"})
    public void exceptionCaught(IoFilter.NextFilter nextFilter, IoSession session, Throwable cause) {
        nextFilter.exceptionCaught(session, cause);
    }

    @IoFilterTransition(on={IoFilterEvents.MESSAGE_RECEIVED}, in={"Done"})
    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) {
        nextFilter.messageReceived(session, message);
    }

    @IoFilterTransition(on={IoFilterEvents.MESSAGE_SENT}, in={"Done"})
    public void messageSent(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) {
        nextFilter.messageSent(session, writeRequest);
    }

    @IoFilterTransition(on={IoFilterEvents.CLOSE}, in={"Root"})
    public void filterClose(IoFilter.NextFilter nextFilter, IoSession session) {
        nextFilter.filterClose(session);
    }

    @IoFilterTransition(on={IoFilterEvents.WRITE}, in={"Root"})
    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) {
        nextFilter.filterWrite(session, writeRequest);
    }

    static class AuthenticationContext
    extends AbstractStateContext {
        private String user;
        private String password;
        private int tries = 0;

        AuthenticationContext() {
        }
    }
}

