/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.sumup;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.RuntimeIOException;
import org.apache.mina.example.sumup.ClientSessionHandler;
import org.apache.mina.example.sumup.codec.SumUpProtocolCodecFactory;
import org.apache.mina.filter.LoggingFilter;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.transport.socket.nio.SocketConnector;
import org.apache.mina.transport.socket.nio.SocketConnectorConfig;

public class Client {
    private static final String HOSTNAME = "localhost";
    private static final int PORT = 8080;
    private static final int CONNECT_TIMEOUT = 30;
    private static final boolean USE_CUSTOM_CODEC = true;

    public static void main(String[] args) throws Throwable {
        IoSession session;
        if (args.length == 0) {
            System.out.println("Please specify the list of any integers");
            return;
        }
        int[] values = new int[args.length];
        for (int i = 0; i < args.length; ++i) {
            values[i] = Integer.parseInt(args[i]);
        }
        SocketConnector connector = new SocketConnector();
        connector.setWorkerTimeout(1);
        SocketConnectorConfig cfg = new SocketConnectorConfig();
        cfg.setConnectTimeout(30);
        cfg.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new SumUpProtocolCodecFactory(false)));
        cfg.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        while (true) {
            try {
                ConnectFuture future = connector.connect((SocketAddress)new InetSocketAddress(HOSTNAME, 8080), (IoHandler)new ClientSessionHandler(values), (IoServiceConfig)cfg);
                future.join();
                session = future.getSession();
            }
            catch (RuntimeIOException e) {
                System.err.println("Failed to connect.");
                e.printStackTrace();
                Thread.sleep(5000L);
                continue;
            }
            break;
        }
        session.getCloseFuture().join();
    }
}

