/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.proxy;

import java.nio.charset.Charset;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.TrafficMask;
import org.apache.mina.util.SessionLog;

public abstract class AbstractProxyIoHandler
extends IoHandlerAdapter {
    private static Charset CHARSET = Charset.forName("iso8859-1");

    public void sessionCreated(IoSession session) throws Exception {
        session.setTrafficMask(TrafficMask.NONE);
    }

    public void sessionClosed(IoSession session) throws Exception {
        if (session.getAttachment() != null) {
            ((IoSession)session.getAttachment()).setAttachment(null);
            ((IoSession)session.getAttachment()).close();
            session.setAttachment(null);
        }
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        ByteBuffer rb = (ByteBuffer)message;
        ByteBuffer wb = ByteBuffer.allocate((int)rb.remaining());
        rb.mark();
        wb.put(rb);
        wb.flip();
        ((IoSession)session.getAttachment()).write((Object)wb);
        rb.reset();
        SessionLog.info((IoSession)session, (String)rb.getString(CHARSET.newDecoder()));
    }
}

