/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.chat.client;

import java.awt.Component;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ConnectDialog
extends JDialog {
    private static final long serialVersionUID = 2009384520250666216L;
    private String serverAddress = "localhost:1234";
    private String username = "user" + Math.round(Math.random() * 10.0);
    private boolean useSsl;
    private boolean cancelled = false;

    public ConnectDialog(Frame owner) throws HeadlessException {
        super(owner, "Connect", true);
        final JTextField serverAddressField = new JTextField(this.serverAddress);
        final JTextField usernameField = new JTextField(this.username);
        final JCheckBox useSslCheckBox = new JCheckBox("Use SSL", false);
        JPanel content = new JPanel();
        content.setLayout(new BoxLayout(content, 3));
        content.add(new JLabel("Server address"));
        content.add(serverAddressField);
        content.add(new JLabel("Username"));
        content.add(usernameField);
        content.add(useSslCheckBox);
        JButton okButton = new JButton();
        okButton.setAction(new AbstractAction("OK"){
            private static final long serialVersionUID = -2292183622613960604L;

            public void actionPerformed(ActionEvent e) {
                ConnectDialog.this.serverAddress = serverAddressField.getText();
                ConnectDialog.this.username = usernameField.getText();
                ConnectDialog.this.useSsl = useSslCheckBox.isSelected();
                ConnectDialog.this.dispose();
            }
        });
        JButton cancelButton = new JButton();
        cancelButton.setAction(new AbstractAction("Cancel"){
            private static final long serialVersionUID = 6122393546173723305L;

            public void actionPerformed(ActionEvent e) {
                ConnectDialog.this.cancelled = true;
                ConnectDialog.this.dispose();
            }
        });
        JPanel buttons = new JPanel();
        buttons.add(okButton);
        buttons.add(cancelButton);
        this.getContentPane().add((Component)content, "Center");
        this.getContentPane().add((Component)buttons, "South");
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isUseSsl() {
        return this.useSsl;
    }
}

