/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.httpserver.codec;

import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetEncoder;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.example.httpserver.codec.HttpResponseMessage;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.apache.mina.filter.codec.demux.MessageEncoder;
import org.apache.mina.util.CharsetUtil;

public class HttpResponseEncoder
implements MessageEncoder {
    private static final Set TYPES;
    private static final byte[] CRLF;

    public void encode(IoSession session, Object message, ProtocolEncoderOutput out) throws Exception {
        HttpResponseMessage msg = (HttpResponseMessage)message;
        ByteBuffer buf = ByteBuffer.allocate((int)256);
        buf.setAutoExpand(true);
        try {
            CharsetEncoder encoder = CharsetUtil.getDefaultCharset().newEncoder();
            buf.putString((CharSequence)"HTTP/1.1 ", encoder);
            buf.putString((CharSequence)String.valueOf(msg.getResponseCode()), encoder);
            switch (msg.getResponseCode()) {
                case 200: {
                    buf.putString((CharSequence)" OK", encoder);
                    break;
                }
                case 404: {
                    buf.putString((CharSequence)" Not Found", encoder);
                }
            }
            buf.put(CRLF);
            Iterator it = msg.getHeaders().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                buf.putString((CharSequence)((String)entry.getKey()), encoder);
                buf.putString((CharSequence)": ", encoder);
                buf.putString((CharSequence)((String)entry.getValue()), encoder);
                buf.put(CRLF);
            }
            buf.putString((CharSequence)"Content-Length: ", encoder);
            buf.putString((CharSequence)String.valueOf(msg.getBodyLength()), encoder);
            buf.put(CRLF);
            buf.put(CRLF);
            buf.put(msg.getBody());
        }
        catch (CharacterCodingException ex) {
            ex.printStackTrace();
        }
        buf.flip();
        out.write(buf);
    }

    public Set getMessageTypes() {
        return TYPES;
    }

    static {
        HashSet<Class> types = new HashSet<Class>();
        types.add(HttpResponseMessage.class);
        TYPES = Collections.unmodifiableSet(types);
        CRLF = new byte[]{13, 10};
    }
}

