/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.netcat;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;

public class NetCatProtocolHandler
extends IoHandlerAdapter {
    public void sessionOpened(IoSession session) {
        session.setIdleTime(IdleStatus.READER_IDLE, 10);
    }

    public void sessionClosed(IoSession session) {
        System.err.println("Total " + session.getReadBytes() + " byte(s)");
    }

    public void sessionIdle(IoSession session, IdleStatus status) {
        if (status == IdleStatus.READER_IDLE) {
            session.close();
        }
    }

    public void messageReceived(IoSession session, Object message) {
        ByteBuffer buf = (ByteBuffer)message;
        while (buf.hasRemaining()) {
            System.out.print((char)buf.get());
        }
        System.out.flush();
    }
}

