/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.coap.resource;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.mina.api.IoSession;
import org.apache.mina.coap.CoapCode;
import org.apache.mina.coap.CoapMessage;
import org.apache.mina.coap.CoapOption;
import org.apache.mina.coap.CoapOptionType;
import org.apache.mina.coap.MessageType;
import org.apache.mina.coap.resource.CoapResponse;
import org.apache.mina.coap.resource.ResourceHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceRegistry.class);
    private Map<String, ResourceHandler> handlers = new HashMap<String, ResourceHandler>();

    public void register(ResourceHandler handler) {
        this.handlers.put(handler.getPath(), handler);
    }

    public CoapMessage respond(CoapMessage request, IoSession session) {
        StringBuilder urlBuilder = new StringBuilder("");
        for (CoapOption opt : request.getOptions()) {
            if (opt.getType() != CoapOptionType.URI_PATH) continue;
            if (urlBuilder.length() > 0) {
                urlBuilder.append("/");
            }
            urlBuilder.append(new String(opt.getData()));
        }
        String url = urlBuilder.toString();
        LOG.debug("requested URL : {}", (Object)url);
        if (url.length() < 1) {
            return new CoapMessage(1, MessageType.ACK, CoapCode.BAD_REQUEST.getCode(), request.getId(), request.getToken(), new CoapOption[]{new CoapOption(CoapOptionType.CONTENT_FORMAT, new byte[]{0})}, "no URL !".getBytes());
        }
        if (".well-known/core".equalsIgnoreCase(url)) {
            return new CoapMessage(1, MessageType.ACK, CoapCode.CONTENT.getCode(), request.getId(), request.getToken(), new CoapOption[]{new CoapOption(CoapOptionType.CONTENT_FORMAT, new byte[]{40})}, this.getDiscovery());
        }
        ResourceHandler handler = this.handlers.get(url);
        if (handler == null) {
            return new CoapMessage(1, MessageType.ACK, CoapCode.NOT_FOUND.getCode(), request.getId(), request.getToken(), new CoapOption[]{new CoapOption(CoapOptionType.CONTENT_FORMAT, new byte[]{0})}, "not found !".getBytes());
        }
        CoapResponse response = handler.handle(request, session);
        return new CoapMessage(1, request.getType() == MessageType.CONFIRMABLE ? MessageType.ACK : MessageType.NON_CONFIRMABLE, response.getCode(), request.getId(), request.getToken(), response.getOptions(), response.getContent());
    }

    private byte[] getDiscovery() {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, ResourceHandler> e : this.handlers.entrySet()) {
            if (first) {
                first = false;
            } else {
                b.append(",");
            }
            ResourceHandler h = e.getValue();
            b.append("</").append(h.getPath()).append(">");
            if (h.getInterface() != null) {
                b.append(";if=\"").append(h.getInterface()).append("\"");
            }
            if (h.getResourceType() != null) {
                b.append(";rt=\"").append(h.getResourceType()).append("\"");
            }
            if (h.getTittle() == null) continue;
            b.append(";title=\"").append(h.getTittle()).append("\"");
        }
        try {
            return b.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            throw new IllegalStateException("no UTF-8 codec", e1);
        }
    }
}

