/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.coap.codec;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.mina.coap.CoapMessage;
import org.apache.mina.coap.CoapOption;
import org.apache.mina.codec.StatelessProtocolEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoapEncoder
implements StatelessProtocolEncoder<CoapMessage, ByteBuffer> {
    private static final Logger LOG = LoggerFactory.getLogger(CoapEncoder.class);
    private static final int HEADER_SIZE = 4;

    public Void createEncoderState() {
        return null;
    }

    public ByteBuffer encode(CoapMessage message, Void context) {
        LOG.debug("encoding {}", (Object)message);
        int size = 4 + message.getToken().length;
        int delta = 0;
        for (CoapOption opt : message.getOptions()) {
            int code = opt.getType().getCode();
            delta = code - delta;
            if (delta < 13) {
                ++size;
            } else if (delta < 269) {
                size += 2;
            } else if (delta < 65805) {
                size += 3;
            }
            int optLength = opt.getData().length;
            if (optLength < 13) {
                size += 0;
            } else if (optLength < 269) {
                ++size;
            } else if (optLength < 65805) {
                size += 2;
            }
            size += optLength;
        }
        if (message.getPayload() != null && message.getPayload().length > 0) {
            ++size;
            size += message.getPayload().length;
        }
        ByteBuffer buffer = ByteBuffer.allocate(size);
        buffer.order(ByteOrder.BIG_ENDIAN);
        buffer.put((byte)((message.getVersion() & 3) << 6 | (message.getType().getCode() & 3) << 4 | message.getToken().length & 0xF));
        buffer.put((byte)message.getCode());
        buffer.putShort((short)message.getId());
        buffer.put(message.getToken());
        int lastOptCode = 0;
        for (CoapOption opt : message.getOptions()) {
            int optionDelta = opt.getType().getCode() - lastOptCode;
            int deltaQuartet = this.getQuartet(optionDelta);
            int optionLength = opt.getData().length;
            int optionQuartet = this.getQuartet(optionLength);
            buffer.put((byte)(deltaQuartet << 4 | optionQuartet));
            if (deltaQuartet == 13) {
                buffer.put((byte)(optionDelta - 13));
            } else if (deltaQuartet == 14) {
                buffer.putShort((short)(optionDelta - 269));
            }
            if (optionQuartet == 13) {
                buffer.put((byte)(optionLength - 13));
            } else if (optionQuartet == 14) {
                buffer.putShort((short)(optionLength - 269));
            }
            buffer.put(opt.getData());
            lastOptCode = opt.getType().getCode();
        }
        if (message.getPayload() != null && message.getPayload().length > 0) {
            buffer.put((byte)-1);
            buffer.put(message.getPayload());
        }
        buffer.flip();
        return buffer;
    }

    private int getQuartet(int value) {
        if (value <= 12) {
            return value;
        }
        if (value <= 268) {
            return 13;
        }
        return 14;
    }
}

