/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.coap.codec;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.mina.coap.CoapMessage;
import org.apache.mina.coap.CoapOption;
import org.apache.mina.coap.CoapOptionType;
import org.apache.mina.coap.MessageType;
import org.apache.mina.codec.ProtocolDecoderException;
import org.apache.mina.codec.StatelessProtocolDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoapDecoder
implements StatelessProtocolDecoder<ByteBuffer, CoapMessage> {
    private static final Logger LOG = LoggerFactory.getLogger(CoapDecoder.class);
    private static final CoapOption[] EMPTY_OPTION = new CoapOption[0];
    private static final byte[] EMPTY_PAYLOAD = new byte[0];

    public Void createDecoderState() {
        return null;
    }

    public CoapMessage decode(ByteBuffer input, Void context) {
        LOG.debug("decode");
        if (input.remaining() <= 0) {
            LOG.debug("nothing to decode");
            return null;
        }
        int byte0 = input.get() & 0xFF;
        int version = byte0 >> 6 & 3;
        MessageType type = MessageType.fromCode(byte0 >> 4 & 3);
        byte[] token = new byte[byte0 & 0xF];
        int code = input.get() & 0xFF;
        int id = input.getShort() & 0xFFFF;
        input.get(token);
        int optionCode = 0;
        byte[] payload = EMPTY_PAYLOAD;
        ArrayList<CoapOption> options = new ArrayList<CoapOption>();
        while (input.hasRemaining()) {
            int next = input.get() & 0xFF;
            if (next == 255) {
                payload = new byte[input.remaining()];
                input.get(payload);
                break;
            }
            int optionDeltaQuartet = next >> 4 & 0xF;
            int optionLenQuartet = next & 0xF;
            int optionLength = this.optionFromQuartet(optionLenQuartet, input);
            CoapOptionType optType = CoapOptionType.fromCode(optionCode += this.optionFromQuartet(optionDeltaQuartet, input));
            if (optType == null) {
                throw new ProtocolDecoderException("unknown option code : " + optionCode);
            }
            byte[] optionValue = new byte[optionLength];
            input.get(optionValue);
            options.add(new CoapOption(optType, optionValue));
        }
        if (input.hasRemaining()) {
            throw new ProtocolDecoderException("trailling " + input.remaining() + " bytes in the UDP datagram");
        }
        return new CoapMessage(version, type, code, id, token, options.toArray(EMPTY_OPTION), payload);
    }

    public void finishDecode(Void context) {
    }

    private int optionFromQuartet(int value, ByteBuffer input) {
        if (value < 13) {
            return value;
        }
        if (value == 13) {
            return (input.get() & 0xFF) + 13;
        }
        if (value == 14) {
            return (input.getShort() & 0xFFFF) + 269;
        }
        throw new ProtocolDecoderException("illegal option quartet value : " + value);
    }
}

