/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.coap;

import java.util.Arrays;
import org.apache.mina.coap.CoapOptionType;

public class CoapOption {
    private final CoapOptionType type;
    private final byte[] data;

    public CoapOption(CoapOptionType type, byte[] data) {
        this.type = type;
        this.data = Arrays.copyOf(data, data.length);
    }

    public CoapOptionType getType() {
        return this.type;
    }

    public byte[] getData() {
        return this.data;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CoapOption [type=").append((Object)this.type).append(", data=").append(Arrays.toString(this.data)).append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.data);
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CoapOption other = (CoapOption)obj;
        if (!Arrays.equals(this.data, other.data)) {
            return false;
        }
        return this.type == other.type;
    }
}

