/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.coap;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.mina.coap.CoapCode;
import org.apache.mina.coap.CoapOption;
import org.apache.mina.coap.CoapOptionType;
import org.apache.mina.coap.MessageType;
import org.apache.mina.filter.query.Request;
import org.apache.mina.filter.query.Response;

public class CoapMessage
implements Request,
Response {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private int version;
    private MessageType type;
    private int code;
    private int id;
    private byte[] token;
    private byte[] payload;
    private CoapOption[] options;

    public static final CoapMessage get(String url, boolean confimable) {
        return new CoapMessage(1, confimable ? MessageType.CONFIRMABLE : MessageType.NON_CONFIRMABLE, CoapCode.GET.getCode(), (int)(System.nanoTime() % 65536L), null, CoapMessage.optionsForUrl(url), null);
    }

    public static final CoapMessage post(String url, boolean confimable, byte[] payload) {
        return new CoapMessage(1, confimable ? MessageType.CONFIRMABLE : MessageType.NON_CONFIRMABLE, CoapCode.GET.getCode(), (int)(System.nanoTime() % 65536L), null, CoapMessage.optionsForUrl(url), payload);
    }

    private static final CoapOption[] optionsForUrl(String url) {
        int i;
        String[] parts = url.split("\\?");
        String[] paths = parts[0].split("\\/");
        String[] params = new String[]{};
        if (parts.length > 1) {
            params = parts[1].split("\\&");
        }
        CoapOption[] opt = new CoapOption[paths.length + params.length];
        for (i = 0; i < paths.length; ++i) {
            try {
                opt[i] = new CoapOption(CoapOptionType.URI_PATH, paths[i].getBytes("UTF-8"));
                continue;
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }
        for (i = 0; i < params.length; ++i) {
            try {
                opt[paths.length + i] = new CoapOption(CoapOptionType.URI_QUERY, params[i].getBytes("UTF-8"));
                continue;
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }
        return opt;
    }

    public CoapMessage(int version, MessageType type, int code, int id, byte[] token, CoapOption[] options, byte[] payload) {
        this.version = version;
        this.type = type;
        this.code = code;
        this.id = id;
        this.token = token == null ? EMPTY_BYTE_ARRAY : token;
        this.payload = payload == null ? EMPTY_BYTE_ARRAY : payload;
        this.options = options == null ? new CoapOption[]{} : options;
        Arrays.sort(this.options, new Comparator<CoapOption>(){

            @Override
            public int compare(CoapOption o1, CoapOption o2) {
                return o1.getType().getCode() < o2.getType().getCode() ? -1 : (o1.getType().getCode() == o2.getType().getCode() ? 0 : 1);
            }
        });
    }

    public Object requestId() {
        return this.id;
    }

    public int getVersion() {
        return this.version;
    }

    public int getCode() {
        return this.code;
    }

    public int getId() {
        return this.id;
    }

    public byte[] getToken() {
        return this.token;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public CoapOption[] getOptions() {
        return this.options;
    }

    public MessageType getType() {
        return this.type;
    }

    public String[] getUriPath() {
        return this.strArrayOptions(CoapOptionType.URI_PATH);
    }

    public String[] getUriQuery() {
        return this.strArrayOptions(CoapOptionType.URI_QUERY);
    }

    public String getUriHost() {
        return this.strOption(CoapOptionType.URI_HOST);
    }

    public Integer getUriPort() {
        return this.intOption(CoapOptionType.URI_PORT);
    }

    public String getProxyUri() {
        return this.strOption(CoapOptionType.PROXY_URI);
    }

    public String getProxyScheme() {
        return this.strOption(CoapOptionType.PROXY_SCHEME);
    }

    public Integer getContentFormat() {
        return this.intOption(CoapOptionType.CONTENT_FORMAT);
    }

    public Integer getAccept() {
        return this.intOption(CoapOptionType.ACCEPT);
    }

    public Integer getMaxAge() {
        return this.intOption(CoapOptionType.MAX_AGE);
    }

    public String[] getLocationPath() {
        return this.strArrayOptions(CoapOptionType.LOCATION_PATH);
    }

    public String[] getLocationQuery() {
        return this.strArrayOptions(CoapOptionType.LOCATION_QUERY);
    }

    private String strOption(CoapOptionType type) {
        if (this.options != null) {
            for (CoapOption option : this.options) {
                if (!type.equals((Object)option.getType())) continue;
                try {
                    return new String(option.getData(), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
        return null;
    }

    private String[] strArrayOptions(CoapOptionType type) {
        ArrayList<String> opts = new ArrayList<String>();
        if (this.options != null) {
            for (CoapOption option : this.options) {
                if (!type.equals((Object)option.getType())) continue;
                try {
                    opts.add(new String(option.getData(), "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
        return opts.toArray(new String[0]);
    }

    private Integer intOption(CoapOptionType type) {
        if (this.options != null) {
            for (CoapOption option : this.options) {
                if (!type.equals((Object)option.getType())) continue;
                ByteBuffer bb = ByteBuffer.wrap(option.getData());
                bb.order(ByteOrder.BIG_ENDIAN);
                return bb.getInt();
            }
        }
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        CoapCode c = CoapCode.fromCode(this.code);
        String cstr = c == null ? String.valueOf(this.code) : c.getText();
        builder.append("CoapMessage [version=").append(this.version).append(", type=").append((Object)this.type).append(", code=").append(cstr).append(", id=").append(this.id).append(", token=").append(Arrays.toString(this.token)).append(", payload=").append(Arrays.toString(this.payload)).append(", options=").append(Arrays.toString(this.options)).append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.code;
        result = 31 * result + this.id;
        result = 31 * result + Arrays.hashCode(this.options);
        result = 31 * result + Arrays.hashCode(this.payload);
        result = 31 * result + Arrays.hashCode(this.token);
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + this.version;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CoapMessage other = (CoapMessage)obj;
        if (this.code != other.code) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (!Arrays.equals(this.options, other.options)) {
            return false;
        }
        if (!Arrays.equals(this.payload, other.payload)) {
            return false;
        }
        if (!Arrays.equals(this.token, other.token)) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return this.version == other.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setType(MessageType type) {
        this.type = type;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setToken(byte[] token) {
        this.token = token;
    }

    public void setPayload(byte[] payload) {
        this.payload = payload;
    }

    public void setOptions(CoapOption[] options) {
        this.options = options;
    }
}

