/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.ssh.external;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.Locale;
import org.apache.maven.wagon.AbstractWagon;
import org.apache.maven.wagon.CommandExecutionException;
import org.apache.maven.wagon.CommandExecutor;
import org.apache.maven.wagon.PathUtils;
import org.apache.maven.wagon.PermissionModeUtils;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.Streams;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.providers.ssh.ScpHelper;
import org.apache.maven.wagon.repository.RepositoryPermissions;
import org.apache.maven.wagon.resource.Resource;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class ScpExternalWagon
extends AbstractWagon
implements CommandExecutor {
    private String scpExecutable = "scp";
    private String sshExecutable = "ssh";
    private String scpArgs;
    private String sshArgs;
    private ScpHelper sshTool = new ScpHelper((CommandExecutor)this);
    private static final int SSH_FATAL_EXIT_CODE = 255;

    protected void openConnectionInternal() throws AuthenticationException {
        if (this.authenticationInfo == null) {
            this.authenticationInfo = new AuthenticationInfo();
        }
    }

    public void closeConnection() {
    }

    public boolean getIfNewer(String resourceName, File destination, long timestamp) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        this.fireSessionDebug("getIfNewer in SCP wagon is not supported - performing an unconditional get");
        this.get(resourceName, destination);
        return true;
    }

    private String buildRemoteHost() {
        String username = this.getRepository().getUsername();
        if (username == null) {
            username = this.authenticationInfo.getUserName();
        }
        if (username == null) {
            return this.getRepository().getHost();
        }
        return username + "@" + this.getRepository().getHost();
    }

    public void executeCommand(String command) throws CommandExecutionException {
        this.fireTransferDebug("Executing command: " + command);
        this.executeCommand(command, false);
    }

    public Streams executeCommand(String command, boolean ignoreFailures) throws CommandExecutionException {
        int port;
        File privateKey;
        boolean putty = this.isPuTTY();
        try {
            privateKey = ScpHelper.getPrivateKey((AuthenticationInfo)this.authenticationInfo);
        }
        catch (FileNotFoundException e) {
            throw new CommandExecutionException(e.getMessage());
        }
        Commandline cl = this.createBaseCommandLine(putty, this.sshExecutable, privateKey);
        int n = port = this.repository.getPort() == -1 ? 22 : this.repository.getPort();
        if (port != 22) {
            if (putty) {
                cl.createArgument().setLine("-P " + port);
            } else {
                cl.createArgument().setLine("-p " + port);
            }
        }
        if (this.sshArgs != null) {
            cl.createArgument().setLine(this.sshArgs);
        }
        String remoteHost = this.buildRemoteHost();
        cl.createArgument().setValue(remoteHost);
        cl.createArgument().setValue(command);
        this.fireSessionDebug("Executing command: " + cl.toString());
        try {
            CommandLineUtils.StringStreamConsumer out = new CommandLineUtils.StringStreamConsumer();
            CommandLineUtils.StringStreamConsumer err = new CommandLineUtils.StringStreamConsumer();
            int exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)out, (StreamConsumer)err);
            Streams streams = new Streams();
            streams.setOut(out.getOutput());
            streams.setErr(err.getOutput());
            this.fireSessionDebug(streams.getOut());
            this.fireSessionDebug(streams.getErr());
            if (!(exitCode == 0 || ignoreFailures && exitCode != 255)) {
                throw new CommandExecutionException("Exit code " + exitCode + " - " + err.getOutput());
            }
            return streams;
        }
        catch (CommandLineException e) {
            throw new CommandExecutionException("Error executing command line", (Throwable)e);
        }
    }

    protected boolean isPuTTY() {
        return this.sshExecutable.toLowerCase(Locale.ENGLISH).indexOf("plink") >= 0;
    }

    private Commandline createBaseCommandLine(boolean putty, String executable, File privateKey) {
        Commandline cl = new Commandline();
        cl.setExecutable(executable);
        if (privateKey != null) {
            cl.createArgument().setValue("-i");
            cl.createArgument().setFile(privateKey);
        }
        String password = this.authenticationInfo.getPassword();
        if (putty && password != null) {
            cl.createArgument().setValue("-pw");
            cl.createArgument().setValue(password);
        }
        if (putty) {
            cl.createArgument().setValue("-batch");
        } else {
            cl.createArgument().setValue("-o");
            cl.createArgument().setValue("BatchMode yes");
        }
        return cl;
    }

    private void executeScpCommand(Resource resource, File localFile, boolean put) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        int port;
        File privateKey;
        boolean putty = this.isPuTTYSCP();
        try {
            privateKey = ScpHelper.getPrivateKey((AuthenticationInfo)this.authenticationInfo);
        }
        catch (FileNotFoundException e) {
            this.fireSessionConnectionRefused();
            throw new AuthorizationException(e.getMessage());
        }
        Commandline cl = this.createBaseCommandLine(putty, this.scpExecutable, privateKey);
        cl.setWorkingDirectory(localFile.getParentFile().getAbsolutePath());
        int n = port = this.repository.getPort() == -1 ? 22 : this.repository.getPort();
        if (port != 22) {
            cl.createArgument().setLine("-P " + port);
        }
        if (this.scpArgs != null) {
            cl.createArgument().setLine(this.scpArgs);
        }
        String resourceName = this.normalizeResource(resource);
        String remoteFile = this.getRepository().getBasedir() + "/" + resourceName;
        remoteFile = StringUtils.replace((String)remoteFile, (String)" ", (String)"\\ ");
        String qualifiedRemoteFile = this.buildRemoteHost() + ":" + remoteFile;
        if (put) {
            cl.createArgument().setValue(localFile.getName());
            cl.createArgument().setValue(qualifiedRemoteFile);
        } else {
            cl.createArgument().setValue(qualifiedRemoteFile);
            cl.createArgument().setValue(localFile.getName());
        }
        this.fireSessionDebug("Executing command: " + cl.toString());
        try {
            CommandLineUtils.StringStreamConsumer err = new CommandLineUtils.StringStreamConsumer();
            int exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, null, (StreamConsumer)err);
            if (exitCode != 0) {
                if (!put && err.getOutput().trim().toLowerCase(Locale.ENGLISH).indexOf("no such file or directory") != -1) {
                    throw new ResourceDoesNotExistException(err.getOutput());
                }
                TransferFailedException e = new TransferFailedException("Exit code: " + exitCode + " - " + err.getOutput());
                this.fireTransferError(resource, (Exception)e, put ? 6 : 5);
                throw e;
            }
        }
        catch (CommandLineException e) {
            this.fireTransferError(resource, (Exception)((Object)e), put ? 6 : 5);
            throw new TransferFailedException("Error executing command line", (Throwable)e);
        }
    }

    boolean isPuTTYSCP() {
        return this.scpExecutable.toLowerCase(Locale.ENGLISH).indexOf("pscp") >= 0;
    }

    private String normalizeResource(Resource resource) {
        return StringUtils.replace((String)resource.getName(), (String)"\\", (String)"/");
    }

    public void put(File source, String destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        String dirPerms;
        Resource resource = new Resource(destination);
        this.firePutInitiated(resource, source);
        if (!source.exists()) {
            throw new ResourceDoesNotExistException("Specified source file does not exist: " + source);
        }
        String basedir = this.getRepository().getBasedir();
        String resourceName = StringUtils.replace((String)destination, (String)"\\", (String)"/");
        String dir = PathUtils.dirname((String)resourceName);
        dir = StringUtils.replace((String)dir, (String)"\\", (String)"/");
        String umaskCmd = null;
        if (this.getRepository().getPermissions() != null && (dirPerms = this.getRepository().getPermissions().getDirectoryMode()) != null) {
            umaskCmd = "umask " + PermissionModeUtils.getUserMaskFor((String)dirPerms);
        }
        String mkdirCmd = "mkdir -p " + basedir + "/" + dir + "\n";
        if (umaskCmd != null) {
            mkdirCmd = umaskCmd + "; " + mkdirCmd;
        }
        try {
            this.executeCommand(mkdirCmd);
        }
        catch (CommandExecutionException e) {
            this.fireTransferError(resource, (Exception)((Object)e), 6);
            throw new TransferFailedException("Error executing command for transfer", (Throwable)e);
        }
        resource.setContentLength(source.length());
        resource.setLastModified(source.lastModified());
        this.firePutStarted(resource, source);
        this.executeScpCommand(resource, source, true);
        this.postProcessListeners(resource, source, 6);
        try {
            RepositoryPermissions permissions = this.getRepository().getPermissions();
            if (permissions != null && permissions.getGroup() != null) {
                this.executeCommand("chgrp -f " + permissions.getGroup() + " " + basedir + "/" + resourceName + "\n", true);
            }
            if (permissions != null && permissions.getFileMode() != null) {
                this.executeCommand("chmod -f " + permissions.getFileMode() + " " + basedir + "/" + resourceName + "\n", true);
            }
        }
        catch (CommandExecutionException e) {
            this.fireTransferError(resource, (Exception)((Object)e), 6);
            throw new TransferFailedException("Error executing command for transfer", (Throwable)e);
        }
        this.firePutCompleted(resource, source);
    }

    public void get(String resourceName, File destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        String path = StringUtils.replace((String)resourceName, (String)"\\", (String)"/");
        Resource resource = new Resource(path);
        this.fireGetInitiated(resource, destination);
        this.createParentDirectories(destination);
        this.fireGetStarted(resource, destination);
        this.executeScpCommand(resource, destination, false);
        this.postProcessListeners(resource, destination, 5);
        this.fireGetCompleted(resource, destination);
    }

    public List getFileList(String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        return this.sshTool.getFileList(destinationDirectory, this.repository);
    }

    public void putDirectory(File sourceDirectory, String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        this.sshTool.putDirectory((Wagon)this, sourceDirectory, destinationDirectory);
    }

    public boolean resourceExists(String resourceName) throws TransferFailedException, AuthorizationException {
        return this.sshTool.resourceExists(resourceName, this.repository);
    }

    public boolean supportsDirectoryCopy() {
        return true;
    }

    public String getScpExecutable() {
        return this.scpExecutable;
    }

    public void setScpExecutable(String scpExecutable) {
        this.scpExecutable = scpExecutable;
    }

    public String getSshExecutable() {
        return this.sshExecutable;
    }

    public void setSshExecutable(String sshExecutable) {
        this.sshExecutable = sshExecutable;
    }

    public String getScpArgs() {
        return this.scpArgs;
    }

    public void setScpArgs(String scpArgs) {
        this.scpArgs = scpArgs;
    }

    public String getSshArgs() {
        return this.sshArgs;
    }

    public void setSshArgs(String sshArgs) {
        this.sshArgs = sshArgs;
    }
}

