/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.ssh;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.wagon.providers.ssh.ScpCommandFactory;
import org.apache.maven.wagon.providers.ssh.ShellCommand;
import org.apache.maven.wagon.providers.ssh.TestPasswordAuthenticator;
import org.apache.maven.wagon.providers.ssh.TestPublickeyAuthenticator;
import org.apache.mina.core.session.IoSession;
import org.apache.sshd.SshServer;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.KeyPairProvider;
import org.apache.sshd.common.Session;
import org.apache.sshd.common.session.AbstractSession;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.FileSystemFactory;
import org.apache.sshd.server.FileSystemView;
import org.apache.sshd.server.PasswordAuthenticator;
import org.apache.sshd.server.PublickeyAuthenticator;
import org.apache.sshd.server.SshFile;
import org.apache.sshd.server.auth.UserAuthPassword;
import org.apache.sshd.server.auth.UserAuthPublicKey;
import org.apache.sshd.server.filesystem.NativeSshFile;
import org.apache.sshd.server.keyprovider.PEMGeneratorHostKeyProvider;
import org.apache.sshd.server.session.SessionFactory;
import org.apache.sshd.server.shell.ProcessShellFactory;
import org.codehaus.plexus.util.FileUtils;

public class SshServerEmbedded {
    private String wagonProtocol;
    private int port;
    private SshServer sshd;
    private List<String> sshKeysResources = new ArrayList<String>();
    private TestPublickeyAuthenticator publickeyAuthenticator;
    TestPasswordAuthenticator passwordAuthenticator = new TestPasswordAuthenticator();
    private boolean keyAuthz;

    public SshServerEmbedded(String wagonProtocol, List<String> sshKeysResources, boolean keyAuthz) {
        this.wagonProtocol = wagonProtocol;
        this.sshKeysResources = sshKeysResources;
        this.sshd = SshServer.setUpDefaultServer();
        this.keyAuthz = keyAuthz;
        this.publickeyAuthenticator = new TestPublickeyAuthenticator(this.keyAuthz);
    }

    public int start() throws IOException {
        this.sshd.setPort(0);
        this.sshd.setUserAuthFactories(Arrays.asList(new UserAuthPublicKey.Factory(), new UserAuthPassword.Factory()));
        this.sshd.setPublickeyAuthenticator((PublickeyAuthenticator)this.publickeyAuthenticator);
        this.sshd.setPasswordAuthenticator((PasswordAuthenticator)this.passwordAuthenticator);
        this.sshd.setUserAuthFactories(Arrays.asList(new UserAuthPublicKey.Factory(), new UserAuthPassword.Factory()));
        File path = new File("target/keys");
        path.mkdirs();
        path = new File(path, "simple.key");
        path.delete();
        PEMGeneratorHostKeyProvider provider = new PEMGeneratorHostKeyProvider();
        provider.setAlgorithm("RSA");
        provider.setKeySize(1024);
        provider.setPath(path.getPath());
        this.sshd.setKeyPairProvider((KeyPairProvider)provider);
        SessionFactory sessionFactory = new SessionFactory(){

            protected AbstractSession doCreateSession(IoSession ioSession) throws Exception {
                return super.doCreateSession(ioSession);
            }
        };
        this.sshd.setSessionFactory(sessionFactory);
        ProcessShellFactory processShellFactory = new ProcessShellFactory(new String[]{"/bin/sh", "-i", "-l"});
        this.sshd.setShellFactory((Factory)processShellFactory);
        CommandFactory delegateCommandFactory = new CommandFactory(){

            public Command createCommand(String command) {
                return new ShellCommand(command);
            }
        };
        ScpCommandFactory commandFactory = new ScpCommandFactory(delegateCommandFactory);
        this.sshd.setCommandFactory((CommandFactory)commandFactory);
        FileSystemFactory fileSystemFactory = new FileSystemFactory(){

            public FileSystemView createFileSystemView(Session session) throws IOException {
                return new FileSystemView(){

                    public SshFile getFile(String file) {
                        file = file.replace("\\", "");
                        file = file.replace("\"", "");
                        File f = new File(FileUtils.normalize((String)file));
                        return new TestSshFile(f.getAbsolutePath(), f, System.getProperty("user.name"));
                    }

                    public SshFile getFile(SshFile baseDir, String file) {
                        file = file.replace("\\", "");
                        file = file.replace("\"", "");
                        File f = new File(FileUtils.normalize((String)file));
                        return new TestSshFile(f.getAbsolutePath(), f, System.getProperty("user.name"));
                    }
                };
            }
        };
        this.sshd.setNioWorkers(0);
        this.sshd.setFileSystemFactory(fileSystemFactory);
        this.sshd.start();
        this.port = this.sshd.getPort();
        return this.port;
    }

    public void stop() throws InterruptedException {
        this.sshd.stop(Boolean.getBoolean("sshd.stopImmediatly"));
    }

    public int getPort() {
        return this.port;
    }

    public PasswordAuthenticator getPasswordAuthenticator() {
        return this.passwordAuthenticator;
    }

    public static class TestSshFile
    extends NativeSshFile {
        public TestSshFile(String fileName, File file, String userName) {
            super(FileUtils.normalize((String)fileName), file, userName);
        }
    }
}

