/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.ssh;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.FileSystemAware;
import org.apache.sshd.server.FileSystemView;
import org.apache.sshd.server.SshFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScpCommand
implements Command,
Runnable,
FileSystemAware {
    protected static final Logger LOG = LoggerFactory.getLogger(ScpCommand.class);
    protected static final int OK = 0;
    protected static final int WARNING = 1;
    protected static final int ERROR = 2;
    protected String name;
    protected boolean optR;
    protected boolean optT;
    protected boolean optF;
    protected boolean optV;
    protected boolean optD;
    protected boolean optP;
    protected FileSystemView root;
    protected String path;
    protected InputStream in;
    protected OutputStream out;
    protected OutputStream err;
    protected ExitCallback callback;
    protected IOException error;

    public ScpCommand(String[] args) {
        this.name = Arrays.asList(args).toString();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing command {}", (Object)this.name);
        }
        this.path = ".";
        for (int i = 1; i < args.length; ++i) {
            if (args[i].charAt(0) == '-') {
                block9: for (int j = 1; j < args[i].length(); ++j) {
                    switch (args[i].charAt(j)) {
                        case 'f': {
                            this.optF = true;
                            continue block9;
                        }
                        case 'p': {
                            this.optP = true;
                            continue block9;
                        }
                        case 'r': {
                            this.optR = true;
                            continue block9;
                        }
                        case 't': {
                            this.optT = true;
                            continue block9;
                        }
                        case 'v': {
                            this.optV = true;
                            continue block9;
                        }
                        case 'd': {
                            this.optD = true;
                            continue block9;
                        }
                    }
                }
                continue;
            }
            if (i != args.length - 1) continue;
            this.path = args[args.length - 1];
        }
        if (!this.optF && !this.optT) {
            this.error = new IOException("Either -f or -t option should be set");
        }
    }

    public void setInputStream(InputStream in) {
        this.in = in;
    }

    public void setOutputStream(OutputStream out) {
        this.out = out;
    }

    public void setErrorStream(OutputStream err) {
        this.err = err;
    }

    public void setExitCallback(ExitCallback callback) {
        this.callback = callback;
    }

    public void start(Environment env) throws IOException {
        if (this.error != null) {
            throw this.error;
        }
        new Thread((Runnable)this, "ScpCommand: " + this.name).start();
    }

    public void destroy() {
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void writeDir(String header, SshFile path) throws IOException {
        SshFile file;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Writing dir {}", (Object)path);
        }
        if (!header.startsWith("D")) {
            throw new IOException("Expected a D message but got '" + header + "'");
        }
        String perms = header.substring(1, 5);
        int length = Integer.parseInt(header.substring(6, header.indexOf(32, 6)));
        String name = header.substring(header.indexOf(32, 6) + 1);
        if (length != 0) {
            throw new IOException("Expected 0 length for directory but got " + length);
        }
        if (path.doesExist() && path.isDirectory()) {
            file = this.root.getFile(path, name);
        } else if (!path.doesExist() && path.getParentFile().doesExist() && path.getParentFile().isDirectory()) {
            file = path;
        } else {
            throw new IOException("Can not write to " + path);
        }
        if (!(file.doesExist() && file.isDirectory() || file.mkdir())) {
            throw new IOException("Could not create directory " + file);
        }
        this.ack();
        while (true) {
            if ((header = this.readLine()).startsWith("C")) {
                this.writeFile(header, file);
                continue;
            }
            if (!header.startsWith("D")) break;
            this.writeDir(header, file);
        }
        if (!header.equals("E")) {
            throw new IOException("Unexpected message: '" + header + "'");
        }
        this.ack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeFile(String header, SshFile path) throws IOException {
        SshFile file;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Writing file {}", (Object)path);
        }
        if (!header.startsWith("C")) {
            throw new IOException("Expected a C message but got '" + header + "'");
        }
        String perms = header.substring(1, 5);
        long length = Long.parseLong(header.substring(6, header.indexOf(32, 6)));
        String name = header.substring(header.indexOf(32, 6) + 1);
        if (path.doesExist() && path.isDirectory()) {
            file = this.root.getFile(path, name);
        } else if (path.doesExist() && path.isFile()) {
            file = path;
        } else if (!path.doesExist() && path.getParentFile().doesExist() && path.getParentFile().isDirectory()) {
            file = path;
        } else {
            throw new IOException("Can not write to " + path);
        }
        if (file.doesExist() && file.isDirectory()) {
            throw new IOException("File is a directory: " + file);
        }
        if (file.doesExist() && !file.isWritable()) {
            throw new IOException("Can not write to file: " + file);
        }
        try (OutputStream os = file.createOutputStream(0L);){
            this.ack();
            byte[] buffer = new byte[8192];
            while (length > 0L) {
                int len = (int)Math.min(length, (long)buffer.length);
                if ((len = this.in.read(buffer, 0, len)) <= 0) {
                    throw new IOException("End of stream reached");
                }
                os.write(buffer, 0, len);
                length -= (long)len;
            }
        }
        this.ack();
        this.readAck(false);
    }

    protected String readLine() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int c;
        while ((c = this.in.read()) != 10) {
            if (c == -1) {
                throw new IOException("End of stream");
            }
            baos.write(c);
        }
        return baos.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readFile(SshFile path) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reading file {}", (Object)path);
        }
        StringBuilder buf = new StringBuilder();
        buf.append("C");
        buf.append("0644");
        buf.append(" ");
        buf.append(path.getSize());
        buf.append(" ");
        buf.append(path.getName());
        buf.append("\n");
        this.out.write(buf.toString().getBytes());
        this.out.flush();
        this.readAck(false);
        try (InputStream is = path.createInputStream(0L);){
            int len;
            byte[] buffer = new byte[8192];
            while ((len = is.read(buffer, 0, buffer.length)) != -1) {
                this.out.write(buffer, 0, len);
            }
        }
        this.ack();
        this.readAck(false);
    }

    protected void readDir(SshFile path) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reading directory {}", (Object)path);
        }
        StringBuilder buf = new StringBuilder();
        buf.append("D");
        buf.append("0755");
        buf.append(" ");
        buf.append("0");
        buf.append(" ");
        buf.append(path.getName());
        buf.append("\n");
        this.out.write(buf.toString().getBytes());
        this.out.flush();
        this.readAck(false);
        for (SshFile child : path.listSshFiles()) {
            if (child.isFile()) {
                this.readFile(child);
                continue;
            }
            if (!child.isDirectory()) continue;
            this.readDir(child);
        }
        this.out.write("E\n".getBytes());
        this.out.flush();
        this.readAck(false);
    }

    protected void ack() throws IOException {
        this.out.write(0);
        this.out.flush();
    }

    protected int readAck(boolean canEof) throws IOException {
        int c = this.in.read();
        switch (c) {
            case -1: {
                if (canEof) break;
                throw new EOFException();
            }
            case 0: {
                break;
            }
            case 1: {
                LOG.warn("Received warning: " + this.readLine());
                break;
            }
            case 2: {
                throw new IOException("Received nack: " + this.readLine());
            }
        }
        return c;
    }

    public void setFileSystemView(FileSystemView view) {
        this.root = view;
    }
}

