/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.ssh;

import java.io.File;
import java.util.Arrays;
import org.apache.maven.wagon.StreamingWagonTestCase;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.providers.ssh.SshServerEmbedded;
import org.apache.maven.wagon.providers.ssh.TestData;
import org.apache.maven.wagon.providers.ssh.TestPasswordAuthenticator;
import org.apache.maven.wagon.repository.Repository;
import org.apache.maven.wagon.resource.Resource;

public abstract class AbstractEmbeddedScpWagonTest
extends StreamingWagonTestCase {
    SshServerEmbedded sshServer;

    protected void setUp() throws Exception {
        super.setUp();
        String sshKeyResource = "ssh-keys/id_rsa";
        this.sshServer = new SshServerEmbedded(this.getProtocol(), Arrays.asList(sshKeyResource), false);
        this.sshServer.start();
        System.out.println("sshd on port " + this.sshServer.getPort());
    }

    protected void tearDownWagonTestingFixtures() throws Exception {
        for (TestPasswordAuthenticator.PasswordAuthenticatorRequest request : this.sshServer.passwordAuthenticator.requests) {
            AbstractEmbeddedScpWagonTest.assertEquals((String)TestData.getUserName(), (String)request.getUsername());
            AbstractEmbeddedScpWagonTest.assertEquals((String)TestData.getUserPassword(), (String)request.getPassword());
        }
        this.sshServer.stop();
    }

    protected abstract String getProtocol();

    protected int getTestRepositoryPort() {
        return this.sshServer.getPort();
    }

    public String getTestRepositoryUrl() {
        return TestData.getTestRepositoryUrl(this.sshServer.getPort());
    }

    protected AuthenticationInfo getAuthInfo() {
        AuthenticationInfo authInfo = super.getAuthInfo();
        authInfo.setUserName(TestData.getUserName());
        authInfo.setPassword(TestData.getUserPassword());
        return authInfo;
    }

    protected long getExpectedLastModifiedOnGet(Repository repository, Resource resource) {
        return new File(repository.getBasedir(), resource.getName()).lastModified();
    }

    protected abstract boolean supportsGetIfNewer();
}

