/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.ftp;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.net.ProtocolCommandEvent;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.InputData;
import org.apache.maven.wagon.OutputData;
import org.apache.maven.wagon.PathUtils;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.StreamWagon;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.repository.RepositoryPermissions;
import org.apache.maven.wagon.resource.Resource;

public class FtpWagon
extends StreamWagon {
    private FTPClient ftp;
    private boolean passiveMode = true;
    private String controlEncoding = "ISO-8859-1";

    public boolean isPassiveMode() {
        return this.passiveMode;
    }

    public void setPassiveMode(boolean passiveMode) {
        this.passiveMode = passiveMode;
    }

    protected void openConnectionInternal() throws ConnectionException, AuthenticationException {
        AuthenticationInfo authInfo = this.getAuthenticationInfo();
        if (authInfo == null) {
            throw new NullPointerException("authenticationInfo cannot be null");
        }
        if (authInfo.getUserName() == null) {
            authInfo.setUserName(System.getProperty("user.name"));
        }
        String username = authInfo.getUserName();
        String password = authInfo.getPassword();
        if (username == null) {
            throw new AuthenticationException("Username not specified for repository " + this.getRepository().getId());
        }
        if (password == null) {
            throw new AuthenticationException("Password not specified for repository " + this.getRepository().getId());
        }
        String host = this.getRepository().getHost();
        this.ftp = this.createClient();
        this.ftp.setDefaultTimeout(this.getTimeout());
        this.ftp.setDataTimeout(this.getTimeout());
        this.ftp.setControlEncoding(this.getControlEncoding());
        this.ftp.addProtocolCommandListener((ProtocolCommandListener)new PrintCommandListener(this));
        try {
            if (this.getRepository().getPort() != -1) {
                this.ftp.connect(host, this.getRepository().getPort());
            } else {
                this.ftp.connect(host);
            }
            int reply = this.ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                this.ftp.disconnect();
                throw new AuthenticationException("FTP server refused connection.");
            }
        }
        catch (IOException e) {
            if (this.ftp.isConnected()) {
                try {
                    this.fireSessionError(e);
                    this.ftp.disconnect();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new AuthenticationException("Could not connect to server.", (Throwable)e);
        }
        try {
            if (!this.ftp.login(username, password)) {
                throw new AuthenticationException("Cannot login to remote system");
            }
            this.fireSessionDebug("Remote system is " + this.ftp.getSystemName());
            this.ftp.setFileType(2);
            this.ftp.setListHiddenFiles(true);
            if (this.isPassiveMode()) {
                this.ftp.enterLocalPassiveMode();
            }
        }
        catch (IOException e) {
            throw new ConnectionException("Cannot login to remote system", (Throwable)e);
        }
    }

    protected FTPClient createClient() {
        return new FTPClient();
    }

    protected void firePutCompleted(Resource resource, File file) {
        try {
            this.ftp.completePendingCommand();
            RepositoryPermissions permissions = this.repository.getPermissions();
            if (permissions != null && permissions.getGroup() != null) {
                this.ftp.sendSiteCommand("CHGRP " + permissions.getGroup() + " " + resource.getName());
            }
            if (permissions != null && permissions.getFileMode() != null) {
                this.ftp.sendSiteCommand("CHMOD " + permissions.getFileMode() + " " + resource.getName());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.firePutCompleted(resource, file);
    }

    protected void fireGetCompleted(Resource resource, File localFile) {
        try {
            this.ftp.completePendingCommand();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.fireGetCompleted(resource, localFile);
    }

    public void closeConnection() throws ConnectionException {
        if (this.ftp != null && this.ftp.isConnected()) {
            try {
                this.ftp.disconnect();
            }
            catch (IOException e) {
                throw new ConnectionException("Failed to close connection to FTP repository", (Throwable)e);
            }
        }
    }

    public void fillOutputData(OutputData outputData) throws TransferFailedException {
        OutputStream os;
        Resource resource = outputData.getResource();
        RepositoryPermissions permissions = this.repository.getPermissions();
        try {
            String[] dirs;
            if (!this.ftp.changeWorkingDirectory(this.getRepository().getBasedir())) {
                throw new TransferFailedException("Required directory: '" + this.getRepository().getBasedir() + "' is missing");
            }
            for (String dir : dirs = PathUtils.dirnames((String)resource.getName())) {
                boolean success;
                boolean dirChanged = this.ftp.changeWorkingDirectory(dir);
                if (!dirChanged && (success = this.ftp.makeDirectory(dir))) {
                    if (permissions != null && permissions.getGroup() != null) {
                        this.ftp.sendSiteCommand("CHGRP " + permissions.getGroup() + " " + dir);
                    }
                    if (permissions != null && permissions.getDirectoryMode() != null) {
                        this.ftp.sendSiteCommand("CHMOD " + permissions.getDirectoryMode() + " " + dir);
                    }
                    dirChanged = this.ftp.changeWorkingDirectory(dir);
                }
                if (dirChanged) continue;
                throw new TransferFailedException("Unable to create directory " + dir);
            }
            if (!this.ftp.changeWorkingDirectory(this.getRepository().getBasedir())) {
                throw new TransferFailedException("Unable to return to the base directory");
            }
            os = this.ftp.storeFileStream(resource.getName());
            if (os == null) {
                String msg = "Cannot transfer resource:  '" + resource + "'. Output stream is null. FTP Server response: " + this.ftp.getReplyString();
                throw new TransferFailedException(msg);
            }
            this.fireTransferDebug("resource = " + resource);
        }
        catch (IOException e) {
            throw new TransferFailedException("Error transferring over FTP", (Throwable)e);
        }
        outputData.setOutputStream(os);
    }

    public void fillInputData(InputData inputData) throws TransferFailedException, ResourceDoesNotExistException {
        InputStream is;
        Resource resource = inputData.getResource();
        try {
            this.ftpChangeDirectory(resource);
            String filename = PathUtils.filename((String)resource.getName());
            FTPFile[] ftpFiles = this.ftp.listFiles(filename);
            if (ftpFiles == null || ftpFiles.length <= 0) {
                throw new ResourceDoesNotExistException("Could not find file: '" + resource + "'");
            }
            long contentLength = ftpFiles[0].getSize();
            Calendar timestamp = ftpFiles[0].getTimestamp();
            long lastModified = timestamp != null ? timestamp.getTimeInMillis() : 0L;
            resource.setContentLength(contentLength);
            resource.setLastModified(lastModified);
            is = this.ftp.retrieveFileStream(filename);
        }
        catch (IOException e) {
            throw new TransferFailedException("Error transferring file via FTP", (Throwable)e);
        }
        inputData.setInputStream(is);
    }

    private void ftpChangeDirectory(Resource resource) throws IOException, TransferFailedException, ResourceDoesNotExistException {
        String[] dirs;
        if (!this.ftp.changeWorkingDirectory(this.getRepository().getBasedir())) {
            throw new ResourceDoesNotExistException("Required directory: '" + this.getRepository().getBasedir() + "' is missing");
        }
        for (String dir : dirs = PathUtils.dirnames((String)resource.getName())) {
            boolean dirChanged = this.ftp.changeWorkingDirectory(dir);
            if (dirChanged) continue;
            String msg = "Resource " + resource + " not found. Directory " + dir + " does not exist";
            throw new ResourceDoesNotExistException(msg);
        }
    }

    protected void fireSessionDebug(String msg) {
        super.fireSessionDebug(msg);
    }

    public List<String> getFileList(String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = new Resource(destinationDirectory);
        try {
            this.ftpChangeDirectory(resource);
            String filename = PathUtils.filename((String)resource.getName());
            FTPFile[] ftpFiles = this.ftp.listFiles(filename);
            if (ftpFiles == null || ftpFiles.length <= 0) {
                throw new ResourceDoesNotExistException("Could not find file: '" + resource + "'");
            }
            ArrayList<String> ret = new ArrayList<String>();
            for (FTPFile file : ftpFiles) {
                String name = file.getName();
                if (file.isDirectory() && !name.endsWith("/")) {
                    name = name + "/";
                }
                ret.add(name);
            }
            return ret;
        }
        catch (IOException e) {
            throw new TransferFailedException("Error transferring file via FTP", (Throwable)e);
        }
    }

    public boolean resourceExists(String resourceName) throws TransferFailedException, AuthorizationException {
        Resource resource = new Resource(resourceName);
        try {
            this.ftpChangeDirectory(resource);
            String filename = PathUtils.filename((String)resource.getName());
            int status = this.ftp.stat(filename);
            return status == 213 || status == 212 || status == 150 || status == 200 || status == 211;
        }
        catch (IOException e) {
            throw new TransferFailedException("Error transferring file via FTP", (Throwable)e);
        }
        catch (ResourceDoesNotExistException e) {
            return false;
        }
    }

    public boolean supportsDirectoryCopy() {
        return true;
    }

    public void putDirectory(File sourceDirectory, String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        try {
            if (!this.ftp.changeWorkingDirectory(this.getRepository().getBasedir())) {
                RepositoryPermissions permissions = this.getRepository().getPermissions();
                if (!this.makeFtpDirectoryRecursive(this.getRepository().getBasedir(), permissions)) {
                    throw new TransferFailedException("Required directory: '" + this.getRepository().getBasedir() + "' could not get created");
                }
                if (!this.ftp.changeWorkingDirectory(this.getRepository().getBasedir())) {
                    throw new TransferFailedException("Required directory: '" + this.getRepository().getBasedir() + "' is missing and could not get created");
                }
            }
        }
        catch (IOException e) {
            throw new TransferFailedException("Cannot change to root path " + this.getRepository().getBasedir(), (Throwable)e);
        }
        this.fireTransferDebug("Recursively uploading directory " + sourceDirectory.getAbsolutePath() + " as " + destinationDirectory);
        this.ftpRecursivePut(sourceDirectory, destinationDirectory);
    }

    private void ftpRecursivePut(File sourceFile, String fileName) throws TransferFailedException {
        RepositoryPermissions permissions = this.repository.getPermissions();
        this.fireTransferDebug("processing = " + sourceFile.getAbsolutePath() + " as " + fileName);
        if (sourceFile.isDirectory()) {
            File[] files;
            block24: {
                if (!fileName.equals(".")) {
                    try {
                        if (this.ftp.changeWorkingDirectory(fileName)) break block24;
                        if (this.makeFtpDirectoryRecursive(fileName, permissions)) {
                            if (!this.ftp.changeWorkingDirectory(fileName)) {
                                throw new TransferFailedException("Unable to change cwd on ftp server to " + fileName + " when processing " + sourceFile.getAbsolutePath());
                            }
                            break block24;
                        }
                        throw new TransferFailedException("Unable to create directory " + fileName + " when processing " + sourceFile.getAbsolutePath());
                    }
                    catch (IOException e) {
                        throw new TransferFailedException("IOException caught while processing path at " + sourceFile.getAbsolutePath(), (Throwable)e);
                    }
                }
            }
            if ((files = sourceFile.listFiles()) != null && files.length > 0) {
                this.fireTransferDebug("listing children of = " + sourceFile.getAbsolutePath() + " found " + files.length);
                for (File file : files) {
                    if (!file.isDirectory()) continue;
                    this.ftpRecursivePut(file, file.getName());
                }
                for (File file : files) {
                    if (file.isDirectory()) continue;
                    this.ftpRecursivePut(file, file.getName());
                }
            }
            try {
                this.ftp.changeToParentDirectory();
            }
            catch (IOException e) {
                throw new TransferFailedException("IOException caught while attempting to step up to parent directory after successfully processing " + sourceFile.getAbsolutePath(), (Throwable)e);
            }
        }
        FileInputStream sourceFileStream = null;
        try {
            sourceFileStream = new FileInputStream(sourceFile);
            if (this.ftp.storeFile(fileName, (InputStream)sourceFileStream)) {
                if (permissions != null) {
                    String mode;
                    String group = permissions.getGroup();
                    if (group != null) {
                        try {
                            this.ftp.sendSiteCommand("CHGRP " + permissions.getGroup());
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if ((mode = permissions.getFileMode()) != null) {
                        try {
                            this.ftp.sendSiteCommand("CHMOD " + permissions.getDirectoryMode());
                        }
                        catch (IOException iOException) {}
                    }
                }
            } else {
                String msg = "Cannot transfer resource:  '" + sourceFile.getAbsolutePath() + "' FTP Server response: " + this.ftp.getReplyString();
                throw new TransferFailedException(msg);
            }
            sourceFileStream.close();
            sourceFileStream = null;
        }
        catch (IOException e) {
            try {
                throw new TransferFailedException("IOException caught while attempting to upload " + sourceFile.getAbsolutePath(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(sourceFileStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)sourceFileStream);
        this.fireTransferDebug("completed = " + sourceFile.getAbsolutePath());
    }

    private void setPermissions(RepositoryPermissions permissions) {
        if (permissions != null) {
            String mode;
            String group = permissions.getGroup();
            if (group != null) {
                try {
                    this.ftp.sendSiteCommand("CHGRP " + permissions.getGroup());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if ((mode = permissions.getDirectoryMode()) != null) {
                try {
                    this.ftp.sendSiteCommand("CHMOD " + permissions.getDirectoryMode());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private boolean makeFtpDirectoryRecursive(String fileName, RepositoryPermissions permissions) throws IOException {
        if (fileName == null || fileName.length() == 0 || fileName.replace('/', '_').trim().length() == 0) {
            return false;
        }
        int slashPos = fileName.indexOf("/");
        String oldPwd = null;
        boolean ok = true;
        if (slashPos == 0) {
            oldPwd = this.ftp.printWorkingDirectory();
            this.ftp.changeWorkingDirectory("/");
            fileName = fileName.substring(1);
            slashPos = fileName.indexOf("/");
        }
        if (slashPos >= 0 && slashPos < fileName.length() - 1) {
            if (oldPwd == null) {
                oldPwd = this.ftp.printWorkingDirectory();
            }
            String nextDir = fileName.substring(0, slashPos);
            boolean changedDir = false;
            if (!this.ftp.changeWorkingDirectory(nextDir)) {
                ok &= this.ftp.makeDirectory(nextDir);
            } else {
                changedDir = true;
            }
            if (ok) {
                this.setPermissions(permissions);
                if (!changedDir) {
                    this.ftp.changeWorkingDirectory(nextDir);
                }
                String remainingDirs = fileName.substring(slashPos + 1);
                ok &= this.makeFtpDirectoryRecursive(remainingDirs, permissions);
            }
        } else {
            ok = this.ftp.makeDirectory(fileName);
        }
        if (oldPwd != null) {
            this.ftp.changeWorkingDirectory(oldPwd);
        }
        return ok;
    }

    public String getControlEncoding() {
        return this.controlEncoding;
    }

    public void setControlEncoding(String controlEncoding) {
        this.controlEncoding = controlEncoding;
    }

    public class PrintCommandListener
    implements ProtocolCommandListener {
        private FtpWagon wagon;

        public PrintCommandListener(FtpWagon wagon) {
            this.wagon = wagon;
        }

        public void protocolCommandSent(ProtocolCommandEvent event) {
            this.wagon.fireSessionDebug("Command sent: " + event.getMessage());
        }

        public void protocolReplyReceived(ProtocolCommandEvent event) {
            this.wagon.fireSessionDebug("Reply received: " + event.getMessage());
        }
    }
}

