/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.testng;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.report.ReporterManagerFactory;
import org.apache.maven.surefire.testng.SynchronizedReporterManager;
import org.apache.maven.surefire.testng.TestNGDirectoryTestSuite;
import org.apache.maven.surefire.testng.TestNGExecutor;
import org.apache.maven.surefire.testng.TestNgTestSuite;
import org.apache.maven.surefire.testset.TestSetFailedException;

public class TestNGXmlTestSuite
implements TestNgTestSuite {
    private final List suiteFiles;
    private List suiteFilePaths;
    private final String testSourceDirectory;
    private final ArtifactVersion version;
    private final Map options;
    private final File reportsDirectory;
    private Map testSets;

    public TestNGXmlTestSuite(List suiteFiles, String testSourceDirectory, String artifactVersion, Properties confOptions, File reportsDirectory) {
        this.suiteFiles = suiteFiles;
        this.options = confOptions;
        this.version = new DefaultArtifactVersion(artifactVersion);
        this.testSourceDirectory = testSourceDirectory;
        this.reportsDirectory = reportsDirectory;
    }

    public void execute(ReporterManagerFactory reporterManagerFactory) throws ReporterException, TestSetFailedException {
        if (this.testSets == null) {
            throw new IllegalStateException("You must call locateTestSets before calling execute");
        }
        SynchronizedReporterManager reporter = new SynchronizedReporterManager(reporterManagerFactory.createReporter());
        TestNGDirectoryTestSuite.startTestSuite(reporter, this);
        TestNGExecutor.run(this.suiteFilePaths, this.testSourceDirectory, this.options, this.version, reporter, this, this.reportsDirectory);
        TestNGDirectoryTestSuite.finishTestSuite(reporter, this);
    }

    public void execute(String testSetName, ReporterManagerFactory reporterManagerFactory, ClassLoader classLoader) throws TestSetFailedException {
        throw new TestSetFailedException("Cannot run individual test when suite files are specified");
    }

    public Map locateTestSets(ClassLoader classLoader) throws TestSetFailedException {
        if (this.testSets != null) {
            throw new IllegalStateException("You can't call locateTestSets twice");
        }
        if (this.suiteFiles == null) {
            throw new IllegalStateException("No suite files were specified");
        }
        this.testSets = new HashMap();
        this.suiteFilePaths = new ArrayList();
        Iterator i = this.suiteFiles.iterator();
        while (i.hasNext()) {
            File file = (File)i.next();
            if (!file.exists() || !file.isFile()) {
                throw new TestSetFailedException("Suite file " + file + " is not a valid file");
            }
            this.testSets.put(file, file.getAbsolutePath());
            this.suiteFilePaths.add(file.getAbsolutePath());
        }
        return this.testSets;
    }

    public String getSuiteName() {
        String result = (String)this.options.get("suitename");
        if (result == null) {
            result = "TestSuite";
        }
        return result;
    }
}

