/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.testng.conf;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.surefire.testng.conf.AbstractDirectConfigurator;
import org.apache.maven.surefire.testng.conf.Configurator;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.testng.TestNG;
import org.testng.xml.XmlSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestNGMapConfigurator
implements Configurator {
    @Override
    public void configure(TestNG testng, Map<String, String> options) throws TestSetFailedException {
        Map<String, Object> convertedOptions = this.getConvertedOptions(options);
        testng.configure(convertedOptions);
    }

    @Override
    public void configure(XmlSuite suite, Map<String, String> options) throws TestSetFailedException {
        String threadCountString = options.get("threadcount");
        int threadCount = null != threadCountString ? Integer.parseInt(threadCountString) : 1;
        suite.setThreadCount(threadCount);
        String parallel = options.get("parallel");
        if (parallel != null) {
            suite.setParallel(parallel);
        }
    }

    Map<String, Object> getConvertedOptions(Map<String, String> options) throws TestSetFailedException {
        HashMap<String, Object> convertedOptions = new HashMap<String, Object>();
        convertedOptions.put("-mixed", false);
        for (Map.Entry<String, String> entry : options.entrySet()) {
            String key = entry.getKey();
            Object val = entry.getValue();
            if ("listener".equals(key)) {
                val = AbstractDirectConfigurator.loadListenerClasses(entry.getValue());
            } else if ("objectfactory".equals(key)) {
                val = AbstractDirectConfigurator.loadClass(entry.getValue());
            } else if ("testrunfactory".equals(key)) {
                val = AbstractDirectConfigurator.loadClass(entry.getValue());
            } else if ("reporter".equals(key)) {
                val = this.convertReporterConfig(val);
                key = "reporterslist";
            } else if ("junit".equals(key)) {
                val = this.convert(val, Boolean.class);
            } else if ("skipfailedinvocationcounts".equals(key)) {
                val = this.convert(val, Boolean.class);
            } else if ("mixed".equals(key)) {
                val = this.convert(val, Boolean.class);
            } else if ("configfailurepolicy".equals(key)) {
                val = this.convert(val, String.class);
            } else if ("group-by-instances".equals(key)) {
                val = this.convert(val, Boolean.class);
            } else if ("threadcount".equals(key)) {
                val = this.convert(val, String.class);
            } else if ("suitethreadpoolsize".equals(key)) {
                val = this.convert(val, Integer.class);
            } else if ("dataproviderthreadcount".equals(key)) {
                val = this.convert(val, Integer.class);
            }
            if (key.startsWith("-")) {
                convertedOptions.put(key, val);
                continue;
            }
            convertedOptions.put("-" + key, val);
        }
        return convertedOptions;
    }

    private Object convertReporterConfig(Object val) {
        String reporterConfigClassName = "org.testng.ReporterConfig";
        try {
            Class<?> reporterConfig = Class.forName("org.testng.ReporterConfig");
            Method deserialize = reporterConfig.getMethod("deserialize", String.class);
            Object rc = deserialize.invoke(null, val);
            ArrayList<Object> reportersList = new ArrayList<Object>();
            reportersList.add(rc);
            return reportersList;
        }
        catch (Exception e) {
            return val;
        }
    }

    protected Object convert(Object val, Class<?> type) {
        if (val == null) {
            return null;
        }
        if (type.isAssignableFrom(val.getClass())) {
            return val;
        }
        if ((type == Boolean.class || type == Boolean.TYPE) && val.getClass() == String.class) {
            return Boolean.valueOf((String)val);
        }
        if ((type == Integer.class || type == Integer.TYPE) && val.getClass() == String.class) {
            return Integer.valueOf((String)val);
        }
        if (type == String.class) {
            return val.toString();
        }
        return val;
    }
}

