/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shadefire.surefire.booter;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.shadefire.surefire.api.booter.BaseProviderFactory;
import org.apache.maven.shadefire.surefire.api.cli.CommandLineOption;
import org.apache.maven.shadefire.surefire.api.provider.ProviderParameters;
import org.apache.maven.shadefire.surefire.api.report.ReporterConfiguration;
import org.apache.maven.shadefire.surefire.api.report.ReporterFactory;
import org.apache.maven.shadefire.surefire.api.suite.RunResult;
import org.apache.maven.shadefire.surefire.api.testset.DirectoryScannerParameters;
import org.apache.maven.shadefire.surefire.api.testset.RunOrderParameters;
import org.apache.maven.shadefire.surefire.api.testset.TestArtifactInfo;
import org.apache.maven.shadefire.surefire.api.testset.TestListResolver;
import org.apache.maven.shadefire.surefire.api.testset.TestRequest;
import org.apache.maven.shadefire.surefire.api.util.ReflectionUtils;
import org.apache.maven.shadefire.surefire.api.util.RunOrder;
import org.apache.maven.shadefire.surefire.api.util.SurefireReflectionException;

public final class SurefireReflector {
    private final ClassLoader surefireClassLoader;
    private final Class<?> reporterConfiguration;
    private final Class<?> testRequest;
    private final Class<?> testArtifactInfo;
    private final Class<?> directoryScannerParameters;
    private final Class<?> runOrderParameters;
    private final Class<?> baseProviderFactory;
    private final Class<?> runResult;
    private final Class<?> booterParameters;
    private final Class<?> reporterFactory;
    private final Class<?> testListResolver;
    private final Class<Enum<?>> commandLineOptionsClass;

    public SurefireReflector(ClassLoader surefireClassLoader) {
        this.surefireClassLoader = surefireClassLoader;
        try {
            this.reporterConfiguration = surefireClassLoader.loadClass(ReporterConfiguration.class.getName());
            this.testRequest = surefireClassLoader.loadClass(TestRequest.class.getName());
            this.testArtifactInfo = surefireClassLoader.loadClass(TestArtifactInfo.class.getName());
            this.directoryScannerParameters = surefireClassLoader.loadClass(DirectoryScannerParameters.class.getName());
            this.runOrderParameters = surefireClassLoader.loadClass(RunOrderParameters.class.getName());
            this.baseProviderFactory = surefireClassLoader.loadClass(BaseProviderFactory.class.getName());
            this.reporterFactory = surefireClassLoader.loadClass(ReporterFactory.class.getName());
            this.runResult = surefireClassLoader.loadClass(RunResult.class.getName());
            this.booterParameters = surefireClassLoader.loadClass(ProviderParameters.class.getName());
            this.testListResolver = surefireClassLoader.loadClass(TestListResolver.class.getName());
            this.commandLineOptionsClass = surefireClassLoader.loadClass(CommandLineOption.class.getName());
        }
        catch (ClassNotFoundException e) {
            throw new SurefireReflectionException(e);
        }
    }

    public Object convertIfRunResult(Object result) {
        if (result == null || !this.isRunResult(result)) {
            return result;
        }
        int getCompletedCount1 = (Integer)ReflectionUtils.invokeGetter(result, "getCompletedCount");
        int getErrors = (Integer)ReflectionUtils.invokeGetter(result, "getErrors");
        int getSkipped = (Integer)ReflectionUtils.invokeGetter(result, "getSkipped");
        int getFailures = (Integer)ReflectionUtils.invokeGetter(result, "getFailures");
        return new RunResult(getCompletedCount1, getErrors, getFailures, getSkipped);
    }

    private Object createTestRequest(TestRequest suiteDefinition) {
        if (suiteDefinition == null) {
            return null;
        }
        Object resolver = this.createTestListResolver(suiteDefinition.getTestListResolver());
        Class[] arguments = new Class[]{List.class, File.class, this.testListResolver, Integer.TYPE};
        Constructor<?> constructor = ReflectionUtils.getConstructor(this.testRequest, arguments);
        return ReflectionUtils.newInstance(constructor, suiteDefinition.getSuiteXmlFiles(), suiteDefinition.getTestSourceDirectory(), resolver, suiteDefinition.getRerunFailingTestsCount());
    }

    private Object createTestListResolver(TestListResolver resolver) {
        if (resolver == null) {
            return null;
        }
        Constructor<?> constructor = ReflectionUtils.getConstructor(this.testListResolver, String.class);
        return ReflectionUtils.newInstance(constructor, resolver.getPluginParameterTest());
    }

    private Object createDirectoryScannerParameters(DirectoryScannerParameters directoryScannerParameters) {
        if (directoryScannerParameters == null) {
            return null;
        }
        Class[] arguments = new Class[]{File.class, List.class, List.class, List.class, String.class};
        Constructor<?> constructor = ReflectionUtils.getConstructor(this.directoryScannerParameters, arguments);
        return ReflectionUtils.newInstance(constructor, directoryScannerParameters.getTestClassesDirectory(), directoryScannerParameters.getIncludes(), directoryScannerParameters.getExcludes(), directoryScannerParameters.getSpecificTests(), RunOrder.asString(directoryScannerParameters.getRunOrder()));
    }

    private Object createRunOrderParameters(RunOrderParameters runOrderParameters) {
        if (runOrderParameters == null) {
            return null;
        }
        Class[] arguments = new Class[]{String.class, File.class, Long.class};
        Constructor<?> constructor = ReflectionUtils.getConstructor(this.runOrderParameters, arguments);
        File runStatisticsFile = runOrderParameters.getRunStatisticsFile();
        return ReflectionUtils.newInstance(constructor, RunOrder.asString(runOrderParameters.getRunOrder()), runStatisticsFile, runOrderParameters.getRunOrderRandomSeed());
    }

    private Object createTestArtifactInfo(TestArtifactInfo testArtifactInfo) {
        if (testArtifactInfo == null) {
            return null;
        }
        Class[] arguments = new Class[]{String.class, String.class};
        Constructor<?> constructor = ReflectionUtils.getConstructor(this.testArtifactInfo, arguments);
        return ReflectionUtils.newInstance(constructor, testArtifactInfo.getVersion(), testArtifactInfo.getClassifier());
    }

    private Object createReporterConfiguration(ReporterConfiguration reporterConfig) {
        Constructor<?> constructor = ReflectionUtils.getConstructor(this.reporterConfiguration, File.class, Boolean.TYPE);
        return ReflectionUtils.newInstance(constructor, reporterConfig.getReportsDirectory(), reporterConfig.isTrimStackTrace());
    }

    public Object createBooterConfiguration(ClassLoader surefireClassLoader, boolean insideFork) {
        return ReflectionUtils.instantiateOneArg(surefireClassLoader, BaseProviderFactory.class.getName(), Boolean.TYPE, insideFork);
    }

    public Object instantiateProvider(String providerClassName, Object booterParameters) {
        return ReflectionUtils.instantiateOneArg(this.surefireClassLoader, providerClassName, this.booterParameters, booterParameters);
    }

    public void setIfDirScannerAware(Object o, DirectoryScannerParameters dirScannerParams) {
        if (this.baseProviderFactory.isAssignableFrom(o.getClass())) {
            this.setDirectoryScannerParameters(o, dirScannerParams);
        }
    }

    public void setMainCliOptions(Object o, List<CommandLineOption> options) {
        if (this.baseProviderFactory.isAssignableFrom(o.getClass())) {
            List<Enum<?>> newOptions = Collections.checkedList(new ArrayList(options.size()), this.commandLineOptionsClass);
            Collection<Integer> ordinals = SurefireReflector.toOrdinals(options);
            for (Enum<?> e : this.commandLineOptionsClass.getEnumConstants()) {
                if (!ordinals.contains(e.ordinal())) continue;
                newOptions.add(e);
            }
            ReflectionUtils.invokeSetter(o, "setMainCliOptions", List.class, newOptions);
        }
    }

    public void setSkipAfterFailureCount(Object o, int skipAfterFailureCount) {
        ReflectionUtils.invokeSetter(o, "setSkipAfterFailureCount", Integer.TYPE, skipAfterFailureCount);
    }

    public void setSystemExitTimeout(Object o, Integer systemExitTimeout) {
        ReflectionUtils.invokeSetter(o, "setSystemExitTimeout", Integer.class, systemExitTimeout);
    }

    void setDirectoryScannerParameters(Object o, DirectoryScannerParameters dirScannerParams) {
        Object param = this.createDirectoryScannerParameters(dirScannerParams);
        ReflectionUtils.invokeSetter(o, "setDirectoryScannerParameters", this.directoryScannerParameters, param);
    }

    public void setRunOrderParameters(Object o, RunOrderParameters runOrderParameters) {
        Object param = this.createRunOrderParameters(runOrderParameters);
        ReflectionUtils.invokeSetter(o, "setRunOrderParameters", this.runOrderParameters, param);
    }

    public void setTestSuiteDefinitionAware(Object o, TestRequest testSuiteDefinition2) {
        if (this.baseProviderFactory.isAssignableFrom(o.getClass())) {
            this.setTestSuiteDefinition(o, testSuiteDefinition2);
        }
    }

    void setTestSuiteDefinition(Object o, TestRequest testSuiteDefinition1) {
        Object param = this.createTestRequest(testSuiteDefinition1);
        ReflectionUtils.invokeSetter(o, "setTestRequest", this.testRequest, param);
    }

    public void setProviderPropertiesAware(Object o, Map<String, String> properties) {
        if (this.baseProviderFactory.isAssignableFrom(o.getClass())) {
            this.setProviderProperties(o, properties);
        }
    }

    void setProviderProperties(Object o, Map<String, String> providerProperties) {
        ReflectionUtils.invokeSetter(o, "setProviderProperties", Map.class, providerProperties);
    }

    public void setReporterConfigurationAware(Object o, ReporterConfiguration reporterConfiguration1) {
        if (this.baseProviderFactory.isAssignableFrom(o.getClass())) {
            this.setReporterConfiguration(o, reporterConfiguration1);
        }
    }

    private void setReporterConfiguration(Object o, ReporterConfiguration reporterConfiguration) {
        Object param = this.createReporterConfiguration(reporterConfiguration);
        ReflectionUtils.invokeSetter(o, "setReporterConfiguration", this.reporterConfiguration, param);
    }

    public void setTestClassLoaderAware(Object o, ClassLoader testClassLoader) {
        if (this.baseProviderFactory.isAssignableFrom(o.getClass())) {
            this.setTestClassLoader(o, testClassLoader);
        }
    }

    void setTestClassLoader(Object o, ClassLoader testClassLoader) {
        Method setter = ReflectionUtils.getMethod(o, "setClassLoaders", ClassLoader.class);
        ReflectionUtils.invokeMethodWithArray(o, setter, testClassLoader);
    }

    public void setTestArtifactInfoAware(Object o, TestArtifactInfo testArtifactInfo1) {
        if (this.baseProviderFactory.isAssignableFrom(o.getClass())) {
            this.setTestArtifactInfo(o, testArtifactInfo1);
        }
    }

    void setTestArtifactInfo(Object o, TestArtifactInfo testArtifactInfo) {
        Object param = this.createTestArtifactInfo(testArtifactInfo);
        ReflectionUtils.invokeSetter(o, "setTestArtifactInfo", this.testArtifactInfo, param);
    }

    public void setReporterFactoryAware(Object o, Object reporterFactory) {
        if (this.baseProviderFactory.isAssignableFrom(o.getClass())) {
            this.setReporterFactory(o, reporterFactory);
        }
    }

    void setReporterFactory(Object o, Object reporterFactory) {
        ReflectionUtils.invokeSetter(o, "setReporterFactory", this.reporterFactory, reporterFactory);
    }

    private boolean isRunResult(Object o) {
        return this.runResult.isAssignableFrom(o.getClass());
    }

    private static Collection<Integer> toOrdinals(Collection<? extends Enum<?>> enums) {
        ArrayList<Integer> ordinals = new ArrayList<Integer>(enums.size());
        for (Enum<?> e : enums) {
            ordinals.add(e.ordinal());
        }
        return ordinals;
    }
}

