/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shadefire.surefire.booter;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.maven.shadefire.surefire.booter.AbstractPathConfiguration;
import org.apache.maven.shadefire.surefire.booter.ClassLoaderConfiguration;
import org.apache.maven.shadefire.surefire.booter.ClasspathConfiguration;
import org.apache.maven.shadefire.surefire.booter.ProcessCheckerType;

public class StartupConfiguration {
    private static final String SUREFIRE_TEST_CLASSPATH = "surefire.test.class.path";
    private final String providerClassName;
    private final AbstractPathConfiguration classpathConfiguration;
    private final ClassLoaderConfiguration classLoaderConfiguration;
    private final ProcessCheckerType processChecker;
    private final List<String[]> jpmsArguments;

    public StartupConfiguration(@Nonnull String providerClassName, @Nonnull AbstractPathConfiguration classpathConfiguration, @Nonnull ClassLoaderConfiguration classLoaderConfiguration, ProcessCheckerType processChecker, @Nonnull List<String[]> jpmsArguments) {
        this.classpathConfiguration = classpathConfiguration;
        this.classLoaderConfiguration = classLoaderConfiguration;
        this.providerClassName = providerClassName;
        this.processChecker = processChecker;
        this.jpmsArguments = jpmsArguments;
    }

    public boolean isProviderMainClass() {
        return this.providerClassName.endsWith("#main");
    }

    public static StartupConfiguration inForkedVm(String providerClassName, ClasspathConfiguration classpathConfig, ClassLoaderConfiguration classLoaderConfig, ProcessCheckerType processChecker) {
        return new StartupConfiguration(providerClassName, classpathConfig, classLoaderConfig, processChecker, Collections.emptyList());
    }

    public AbstractPathConfiguration getClasspathConfiguration() {
        return this.classpathConfiguration;
    }

    public boolean isManifestOnlyJarRequestedAndUsable() {
        return this.classLoaderConfiguration.isManifestOnlyJarRequestedAndUsable();
    }

    public String getProviderClassName() {
        return this.providerClassName;
    }

    public String getActualClassName() {
        return this.isProviderMainClass() ? StartupConfiguration.stripEnd(this.providerClassName, "#main") : this.providerClassName;
    }

    private static String stripEnd(String str, String strip) {
        int end;
        if (str == null) {
            return null;
        }
        if (strip == null) {
            for (end = str.length(); end != 0 && Character.isWhitespace(str.charAt(end - 1)); --end) {
            }
        } else {
            while (end != 0 && strip.indexOf(str.charAt(end - 1)) != -1) {
                --end;
            }
        }
        return str.substring(0, end);
    }

    public ClassLoaderConfiguration getClassLoaderConfiguration() {
        return this.classLoaderConfiguration;
    }

    public boolean isShadefire() {
        return this.providerClassName.startsWith("org.apache.maven.shadefire.shadefire.surefire");
    }

    public void writeSurefireTestClasspathProperty() {
        this.getClasspathConfiguration().getTestClasspath().writeToSystemProperty(SUREFIRE_TEST_CLASSPATH);
    }

    public ProcessCheckerType getProcessChecker() {
        return this.processChecker;
    }

    public List<String[]> getJpmsArguments() {
        return this.jpmsArguments;
    }
}

