/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shadefire.surefire.booter;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Set;

public class IsolatedClassLoader
extends URLClassLoader {
    private final ClassLoader parent = ClassLoader.getSystemClassLoader();
    private final Set<URL> urls = new HashSet<URL>();
    private final String roleName;
    private boolean childDelegation = true;
    private static final URL[] EMPTY_URL_ARRAY = new URL[0];

    public IsolatedClassLoader(ClassLoader parent, boolean childDelegation, String roleName) {
        super(EMPTY_URL_ARRAY, parent);
        this.childDelegation = childDelegation;
        this.roleName = roleName;
    }

    @Override
    @Deprecated
    public void addURL(URL url) {
        if (!this.urls.contains(url)) {
            super.addURL(url);
            this.urls.add(url);
        }
    }

    public synchronized Class loadClass(String name) throws ClassNotFoundException {
        if (this.childDelegation) {
            Class<?> c = this.findLoadedClass(name);
            if (c == null) {
                try {
                    c = this.findClass(name);
                }
                catch (ClassNotFoundException e) {
                    if (this.parent == null) {
                        throw e;
                    }
                    c = this.parent.loadClass(name);
                }
            }
            return c;
        }
        return super.loadClass(name);
    }

    public String toString() {
        return "IsolatedClassLoader{roleName='" + this.roleName + "'}";
    }
}

