/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shadefire.surefire.api.util.internal;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.apache.maven.shadefire.surefire.api.util.internal.AbstractNoninterruptibleReadableChannel;
import org.apache.maven.shadefire.surefire.api.util.internal.AbstractNoninterruptibleWritableChannel;
import org.apache.maven.shadefire.surefire.api.util.internal.WritableBufferedByteChannel;

public final class Channels {
    private static final int BUFFER_SIZE = 65536;

    private Channels() {
        throw new IllegalStateException("no instantiable constructor");
    }

    public static WritableByteChannel newChannel(@Nonnull OutputStream out) {
        return Channels.newChannel(out, 0);
    }

    public static WritableBufferedByteChannel newBufferedChannel(@Nonnull OutputStream out) {
        return Channels.newChannel(out, 65536);
    }

    public static ReadableByteChannel newChannel(@Nonnull InputStream is) {
        return Channels.newChannel(is, 0);
    }

    public static ReadableByteChannel newBufferedChannel(@Nonnull InputStream is) {
        return Channels.newChannel(is, 65536);
    }

    public static OutputStream newOutputStream(final AsynchronousByteChannel channel) {
        return new OutputStream(){

            @Override
            public synchronized void write(byte[] b, int off, int len) throws IOException {
                if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                    throw new IndexOutOfBoundsException("b.length = " + b.length + ", off = " + off + ", len = " + len);
                }
                if (len > 0) {
                    ByteBuffer bb = ByteBuffer.wrap(b, off, len);
                    while (bb.hasRemaining()) {
                        try {
                            channel.write(bb).get();
                        }
                        catch (ExecutionException e) {
                            Throwable t = e.getCause();
                            throw t instanceof IOException ? (IOException)t : new IOException((t == null ? e : t).getLocalizedMessage(), t);
                        }
                        catch (Exception e) {
                            throw new IOException(e.getLocalizedMessage(), e);
                        }
                    }
                }
            }

            @Override
            public void write(int b) throws IOException {
                this.write(new byte[]{(byte)b});
            }

            @Override
            public synchronized void close() throws IOException {
                if (channel.isOpen()) {
                    try {
                        channel.close();
                    }
                    catch (ClosedChannelException closedChannelException) {
                        // empty catch block
                    }
                }
            }
        };
    }

    public static InputStream newInputStream(final AsynchronousByteChannel channel) {
        return new InputStream(){

            @Override
            public synchronized int read(byte[] b, int off, int len) throws IOException {
                if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                    throw new IndexOutOfBoundsException("b.length = " + b.length + ", off = " + off + ", len = " + len);
                }
                if (len == 0) {
                    return 0;
                }
                ByteBuffer bb = ByteBuffer.wrap(b, off, len);
                try {
                    return channel.read(bb).get();
                }
                catch (ExecutionException e) {
                    Throwable t = e.getCause();
                    throw t instanceof IOException ? (IOException)t : new IOException((t == null ? e : t).getLocalizedMessage(), t);
                }
                catch (Exception e) {
                    throw new IOException(e.getLocalizedMessage(), e);
                }
            }

            @Override
            public int read() throws IOException {
                int count;
                byte[] b = new byte[1];
                while ((count = this.read(b, 0, 1)) == 0) {
                }
                return count == -1 ? -1 : b[0];
            }

            @Override
            public synchronized void close() throws IOException {
                if (channel.isOpen()) {
                    try {
                        channel.close();
                    }
                    catch (ClosedChannelException closedChannelException) {
                        // empty catch block
                    }
                }
            }
        };
    }

    private static ReadableByteChannel newChannel(@Nonnull InputStream is, @Nonnegative int bufferSize) {
        Objects.requireNonNull(is, "the stream should not be null");
        final InputStream bis = bufferSize == 0 ? is : new BufferedInputStream(is, bufferSize);
        return new AbstractNoninterruptibleReadableChannel(){

            @Override
            protected int readImpl(ByteBuffer src) throws IOException {
                int count = bis.read(src.array(), src.arrayOffset() + src.position(), src.remaining());
                if (count > 0) {
                    ((Buffer)src).position(count + src.position());
                }
                return count;
            }

            @Override
            protected void closeImpl() throws IOException {
                bis.close();
            }
        };
    }

    private static WritableBufferedByteChannel newChannel(@Nonnull OutputStream out, final @Nonnegative int bufferSize) {
        Objects.requireNonNull(out, "the stream should not be null");
        final OutputStream bos = bufferSize == 0 ? out : new BufferedOutputStream(out, bufferSize);
        return new AbstractNoninterruptibleWritableChannel(){
            private final AtomicLong bytesCounter = new AtomicLong();

            @Override
            public long countBufferOverflows() {
                return bufferSize == 0 ? 0L : Math.max(this.bytesCounter.get() - 1L, 0L) / (long)bufferSize;
            }

            @Override
            protected void writeImpl(ByteBuffer src) throws IOException {
                int count = src.remaining();
                bos.write(src.array(), src.arrayOffset() + src.position(), count);
                this.bytesCounter.getAndAdd(count);
            }

            @Override
            protected void closeImpl() throws IOException {
                bos.close();
            }

            @Override
            protected void flushImpl() throws IOException {
                bos.flush();
            }
        };
    }
}

