/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shadefire.surefire.api.booter;

import java.io.File;
import org.apache.maven.shadefire.surefire.api.util.internal.DumpFileUtils;

public final class DumpErrorSingleton {
    public static final String DUMP_FILE_EXT = ".dump";
    public static final String DUMPSTREAM_FILE_EXT = ".dumpstream";
    private static final DumpErrorSingleton SINGLETON = new DumpErrorSingleton();
    private File dumpFile;
    private File dumpStreamFile;
    private File binaryDumpStreamFile;

    private DumpErrorSingleton() {
    }

    public static DumpErrorSingleton getSingleton() {
        return SINGLETON;
    }

    public synchronized void init(File reportsDir, String dumpFileName) {
        this.dumpFile = this.createDumpFile(reportsDir, dumpFileName);
        this.dumpStreamFile = this.createDumpStreamFile(reportsDir, dumpFileName);
        String fileNameWithoutExtension = dumpFileName.contains(".") ? dumpFileName.substring(0, dumpFileName.lastIndexOf(46)) : dumpFileName;
        this.binaryDumpStreamFile = DumpFileUtils.newDumpFile(reportsDir, fileNameWithoutExtension + "-commands.bin");
    }

    public synchronized File dumpException(Throwable t, String msg) {
        DumpFileUtils.dumpException(t, msg == null ? "null" : msg, this.dumpFile);
        return this.dumpFile;
    }

    public synchronized File dumpException(Throwable t) {
        DumpFileUtils.dumpException(t, this.dumpFile);
        return this.dumpFile;
    }

    public synchronized File dumpText(String msg) {
        DumpFileUtils.dumpText(msg == null ? "null" : msg, this.dumpFile);
        return this.dumpFile;
    }

    public synchronized File dumpStreamException(Throwable t, String msg) {
        DumpFileUtils.dumpException(t, msg == null ? "null" : msg, this.dumpStreamFile);
        return this.dumpStreamFile;
    }

    public synchronized File dumpStreamException(Throwable t) {
        DumpFileUtils.dumpException(t, this.dumpStreamFile);
        return this.dumpStreamFile;
    }

    public synchronized File dumpStreamText(String msg) {
        DumpFileUtils.dumpText(msg == null ? "null" : msg, this.dumpStreamFile);
        return this.dumpStreamFile;
    }

    public File getCommandStreamBinaryFile() {
        return this.binaryDumpStreamFile;
    }

    private File createDumpFile(File reportsDir, String dumpFileName) {
        return DumpFileUtils.newDumpFile(reportsDir, dumpFileName + DUMP_FILE_EXT);
    }

    private File createDumpStreamFile(File reportsDir, String dumpFileName) {
        return DumpFileUtils.newDumpFile(reportsDir, dumpFileName + DUMPSTREAM_FILE_EXT);
    }
}

