/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shadefire.surefire.junit;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.maven.shadefire.surefire.api.report.LegacyPojoStackTraceWriter;
import org.apache.maven.shadefire.surefire.api.report.ReportEntry;
import org.apache.maven.shadefire.surefire.api.report.RunMode;
import org.apache.maven.shadefire.surefire.api.report.SimpleReportEntry;
import org.apache.maven.shadefire.surefire.api.util.internal.TestClassMethodNameUtils;
import org.apache.maven.shadefire.surefire.junit.JUnit3Reporter;

public class TestListenerInvocationHandler
implements InvocationHandler {
    private static final String START_TEST = "startTest";
    private static final String ADD_FAILURE = "addFailure";
    private static final String ADD_ERROR = "addError";
    private static final String END_TEST = "endTest";
    private final Set<FailedTest> failedTestsSet = new HashSet<FailedTest>();
    private final JUnit3Reporter reporter;
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Object[] EMPTY_STRING_ARRAY = new Object[0];

    public TestListenerInvocationHandler(JUnit3Reporter reporter) {
        this.reporter = Objects.requireNonNull(reporter, "reporter is null");
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName;
        switch (methodName = method.getName()) {
            case "startTest": {
                this.handleStartTest(args);
                break;
            }
            case "addError": {
                this.handleAddError(args);
                break;
            }
            case "addFailure": {
                this.handleAddFailure(args);
                break;
            }
            case "endTest": {
                this.handleEndTest(args);
                break;
            }
        }
        return null;
    }

    private void handleStartTest(Object[] args) {
        SimpleReportEntry report = this.createStartEndReportEntry(args);
        this.reporter.testStarting(report);
    }

    private void handleAddError(Object[] args) throws ReflectiveOperationException {
        ReportEntry report = this.toReportEntryWithException(args);
        this.reporter.testError(report);
        this.failedTestsSet.add(new FailedTest(args[0], Thread.currentThread()));
    }

    private static LegacyPojoStackTraceWriter toStackTraceWriter(Object[] args) throws ReflectiveOperationException {
        String testName;
        try {
            Method m = args[0].getClass().getMethod("getName", EMPTY_CLASS_ARRAY);
            testName = (String)m.invoke(args[0], EMPTY_STRING_ARRAY);
        }
        catch (NoSuchMethodException e) {
            testName = "UNKNOWN";
        }
        return new LegacyPojoStackTraceWriter(args[0].getClass().getName(), testName, (Throwable)args[1]);
    }

    private void handleAddFailure(Object[] args) throws ReflectiveOperationException {
        ReportEntry report = this.toReportEntryWithException(args);
        this.reporter.testFailed(report);
        this.failedTestsSet.add(new FailedTest(args[0], Thread.currentThread()));
    }

    private void handleEndTest(Object[] args) {
        boolean testHadFailed = this.failedTestsSet.remove(new FailedTest(args[0], Thread.currentThread()));
        if (!testHadFailed) {
            SimpleReportEntry report = this.createStartEndReportEntry(args);
            this.reporter.testSucceeded(report);
        }
    }

    private ReportEntry toReportEntryWithException(Object[] args) throws ReflectiveOperationException {
        String description = args[0].toString();
        String className = TestClassMethodNameUtils.extractClassName(description);
        String methodName = TestClassMethodNameUtils.extractMethodName(description);
        LegacyPojoStackTraceWriter stackTraceWriter = TestListenerInvocationHandler.toStackTraceWriter(args);
        long testRunId = this.reporter.getClassMethodIndexer().indexClassMethod(className, methodName);
        return SimpleReportEntry.withException(RunMode.NORMAL_RUN, testRunId, className, null, methodName, null, stackTraceWriter);
    }

    private SimpleReportEntry createStartEndReportEntry(Object[] args) {
        String description = args[0].toString();
        String className = TestClassMethodNameUtils.extractClassName(description);
        String methodName = TestClassMethodNameUtils.extractMethodName(description);
        long testRunId = this.reporter.getClassMethodIndexer().indexClassMethod(className, methodName);
        return new SimpleReportEntry(RunMode.NORMAL_RUN, testRunId, className, null, methodName, null);
    }

    private static class FailedTest {
        private final Object testThatFailed;
        private final Thread threadOnWhichTestFailed;

        FailedTest(Object testThatFailed, Thread threadOnWhichTestFailed) {
            this.testThatFailed = Objects.requireNonNull(testThatFailed, "testThatFailed is null");
            this.threadOnWhichTestFailed = Objects.requireNonNull(threadOnWhichTestFailed, "threadOnWhichTestFailed is null");
        }

        public boolean equals(Object obj) {
            boolean retVal = true;
            if (obj == null || this.getClass() != obj.getClass()) {
                retVal = false;
            } else {
                FailedTest ft = (FailedTest)obj;
                if (ft.testThatFailed != this.testThatFailed) {
                    retVal = false;
                } else if (!ft.threadOnWhichTestFailed.equals(this.threadOnWhichTestFailed)) {
                    retVal = false;
                }
            }
            return retVal;
        }

        public int hashCode() {
            return this.threadOnWhichTestFailed.hashCode();
        }
    }
}

