/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shadefire.surefire.booter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.shadefire.surefire.api.util.TempFileManager;
import org.apache.maven.shadefire.surefire.booter.PropertiesWrapper;

public class SystemPropertyManager {
    public static PropertiesWrapper loadProperties(InputStream inStream) throws IOException {
        try (InputStream stream = inStream;){
            Properties p = new Properties();
            p.load(stream);
            ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>(p.size());
            for (String key : p.stringPropertyNames()) {
                map.put(key, p.getProperty(key));
            }
            PropertiesWrapper propertiesWrapper = new PropertiesWrapper(map);
            return propertiesWrapper;
        }
    }

    private static PropertiesWrapper loadProperties(File file) throws IOException {
        return SystemPropertyManager.loadProperties(new FileInputStream(file));
    }

    public static void setSystemProperties(File file) throws IOException {
        PropertiesWrapper p = SystemPropertyManager.loadProperties(file);
        p.setAsSystemProperties();
    }

    public static File writePropertiesFile(Properties properties, File tempDirectory, String name, boolean keepForkFiles) throws IOException {
        File file = TempFileManager.instance(tempDirectory).createTempFile(name, "tmp");
        if (!keepForkFiles) {
            file.deleteOnExit();
        }
        SystemPropertyManager.writePropertiesFile(file, name, properties);
        return file;
    }

    public static void writePropertiesFile(File file, String name, Properties properties) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file);){
            properties.store(out, name);
        }
    }
}

