/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shadefire.surefire.api.testset;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.shadefire.surefire.api.testset.TestListResolver;

public class TestRequest {
    private final List<File> suiteXmlFiles;
    private final File testSourceDirectory;
    private final TestListResolver requestedTests;
    private final int rerunFailingTestsCount;

    public TestRequest(List suiteXmlFiles, File testSourceDirectory, TestListResolver requestedTests) {
        this(TestRequest.createFiles(suiteXmlFiles), testSourceDirectory, requestedTests, 0);
    }

    public TestRequest(List suiteXmlFiles, File testSourceDirectory, TestListResolver requestedTests, int rerunFailingTestsCount) {
        this.suiteXmlFiles = TestRequest.createFiles(suiteXmlFiles);
        this.testSourceDirectory = testSourceDirectory;
        this.requestedTests = requestedTests;
        this.rerunFailingTestsCount = rerunFailingTestsCount;
    }

    public List<File> getSuiteXmlFiles() {
        return this.suiteXmlFiles;
    }

    public File getTestSourceDirectory() {
        return this.testSourceDirectory;
    }

    public TestListResolver getTestListResolver() {
        return this.requestedTests;
    }

    public int getRerunFailingTestsCount() {
        return this.rerunFailingTestsCount;
    }

    private static List<File> createFiles(List suiteXmlFiles) {
        if (suiteXmlFiles != null) {
            ArrayList<File> files = new ArrayList<File>();
            for (Object suiteXmlFile : suiteXmlFiles) {
                Object element = suiteXmlFile;
                files.add(element instanceof String ? new File((String)element) : (File)element);
            }
            return files;
        }
        return null;
    }
}

